% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_event_windows}
\alias{ec2_describe_instance_event_windows}
\title{Describes the specified event windows or all event windows}
\usage{
ec2_describe_instance_event_windows(
  DryRun = NULL,
  InstanceEventWindowIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceEventWindowIds}{The IDs of the event windows.}

\item{Filters}{One or more filters.
\itemize{
\item \code{dedicated-host-id} - The event windows associated with the
specified Dedicated Host ID.
\item \code{event-window-name} - The event windows associated with the
specified names.
\item \code{instance-id} - The event windows associated with the specified
instance ID.
\item \code{instance-tag} - The event windows associated with the specified tag
and value.
\item \code{instance-tag-key} - The event windows associated with the specified
tag key, regardless of the value.
\item \code{instance-tag-value} - The event windows associated with the
specified tag value, regardless of the key.
\item \verb{tag:<key>} - The key/value combination of a tag assigned to the
event window. Use the tag key in the filter name and the tag value
as the filter value. For example, to find all resources that have a
tag with the key \code{Owner} and the value \code{CMX}, specify \code{tag:Owner}
for the filter name and \code{CMX} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the event window. Use this
filter to find all event windows that have a tag with a specific
key, regardless of the tag value.
\item \code{tag-value} - The value of a tag assigned to the event window. Use
this filter to find all event windows that have a tag with a
specific value, regardless of the tag key.
}}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. This value can be between 20 and 500. You cannot specify this
parameter and the event window IDs parameter in the same call.}

\item{NextToken}{The token to request the next page of results.}
}
\description{
Describes the specified event windows or all event windows.

See \url{https://paws-r.github.io/docs/ec2/describe_instance_event_windows.html} for full documentation.
}
\keyword{internal}
