% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_contact_method}
\alias{lightsail_delete_contact_method}
\title{Deletes a contact method}
\usage{
lightsail_delete_contact_method(protocol)
}
\arguments{
\item{protocol}{[required] The protocol that will be deleted, such as \code{Email} or \code{SMS} (text
messaging).

To delete an \code{Email} and an \code{SMS} contact method if you added both, you
must run separate \code{DeleteContactMethod} actions to delete each protocol.}
}
\description{
Deletes a contact method.
}
\details{
A contact method is used to send you notifications about your Amazon
Lightsail resources. You can add one email address and one mobile phone
number contact method in each AWS Region. However, SMS text messaging is
not supported in some AWS Regions, and SMS text messages cannot be sent
to some countries/regions. For more information, see \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications}{Notifications in Amazon Lightsail}.
}
\section{Request syntax}{
\preformatted{svc$delete_contact_method(
  protocol = "Email"|"SMS"
)
}
}

\keyword{internal}
