% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_launch_template_data}
\alias{ec2_get_launch_template_data}
\title{Retrieves the configuration data of the specified instance}
\usage{
ec2_get_launch_template_data(DryRun, InstanceId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceId}{[required] The ID of the instance.}
}
\description{
Retrieves the configuration data of the specified instance. You can use
this data to create a launch template.
}
\details{
This action calls on other describe actions to get instance information.
Depending on your instance configuration, you may need to allow the
following actions in your IAM policy: DescribeSpotInstanceRequests,
DescribeInstanceCreditSpecifications, DescribeVolumes,
DescribeInstanceAttribute, and DescribeElasticGpus. Or, you can allow
\verb{describe*} depending on your instance requirements.
}
\section{Request syntax}{
\preformatted{svc$get_launch_template_data(
  DryRun = TRUE|FALSE,
  InstanceId = "string"
)
}
}

\examples{
\dontrun{
# This example gets the launch template data for the specified instance.
svc$get_launch_template_data(
  InstanceId = "0123d646e8048babc"
)
}

}
\keyword{internal}
