% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_load_balancer}
\alias{lightsail_delete_load_balancer}
\title{Deletes a Lightsail load balancer and all its associated SSL/TLS
certificates}
\usage{
lightsail_delete_load_balancer(loadBalancerName)
}
\arguments{
\item{loadBalancerName}{[required] The name of the load balancer you want to delete.}
}
\description{
Deletes a Lightsail load balancer and all its associated SSL/TLS
certificates. Once the load balancer is deleted, you will need to create
a new load balancer, create a new certificate, and verify domain
ownership again.
}
\details{
The \verb{delete load balancer} operation supports tag-based access control
via resource tags applied to the resource identified by
\verb{load balancer name}. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_load_balancer(
  loadBalancerName = "string"
)
}
}

\keyword{internal}
