% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_open_instance_public_ports}
\alias{lightsail_open_instance_public_ports}
\title{Adds public ports to an Amazon Lightsail instance}
\usage{
lightsail_open_instance_public_ports(portInfo, instanceName)
}
\arguments{
\item{portInfo}{[required] An array of key-value pairs containing information about the port
mappings.}

\item{instanceName}{[required] The name of the instance for which you want to open the public ports.}
}
\description{
Adds public ports to an Amazon Lightsail instance.
}
\details{
The \verb{open instance public ports} operation supports tag-based access
control via resource tags applied to the resource identified by
\verb{instance name}. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$open_instance_public_ports(
  portInfo = list(
    fromPort = 123,
    toPort = 123,
    protocol = "tcp"|"all"|"udp"
  ),
  instanceName = "string"
)
}
}

\keyword{internal}
