% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_tags_for_resource}
\alias{eks_list_tags_for_resource}
\title{List the tags for an Amazon EKS resource}
\usage{
eks_list_tags_for_resource(resourceArn)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) that identifies the resource for which to
list the tags. Currently, the supported resources are Amazon EKS
clusters and managed node groups.}
}
\description{
List the tags for an Amazon EKS resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  resourceArn = "string"
)
}
}

\examples{
# This example lists all of the tags for the `beta` cluster.
\dontrun{svc$list_tags_for_resource(
  resourceArn = "arn:aws:eks:us-west-2:012345678910:cluster/beta"
)}

}
\keyword{internal}
