% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_known_host_keys}
\alias{lightsail_delete_known_host_keys}
\title{Deletes the known host key or certificate used by the Amazon Lightsail
browser-based SSH or RDP clients to authenticate an instance}
\usage{
lightsail_delete_known_host_keys(instanceName)
}
\arguments{
\item{instanceName}{[required] The name of the instance for which you want to reset the host key or
certificate.}
}
\description{
Deletes the known host key or certificate used by the Amazon Lightsail
browser-based SSH or RDP clients to authenticate an instance. This
operation enables the Lightsail browser-based SSH or RDP clients to
connect to the instance after a host key mismatch.

Perform this operation only if you were expecting the host key or
certificate mismatch or if you are familiar with the new host key or
certificate on the instance. For more information, see Troubleshooting
connection issues when using the Amazon Lightsail browser-based SSH or
RDP client.
}
\section{Request syntax}{
\preformatted{svc$delete_known_host_keys(
  instanceName = "string"
)
}
}

\keyword{internal}
