% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_instances_from_snapshot}
\alias{lightsail_create_instances_from_snapshot}
\title{Creates one or more new instances from a manual or automatic snapshot of
an instance}
\usage{
lightsail_create_instances_from_snapshot(instanceNames,
  attachedDiskMapping, availabilityZone, instanceSnapshotName, bundleId,
  userData, keyPairName, tags, addOns, sourceInstanceName, restoreDate,
  useLatestRestorableAutoSnapshot)
}
\arguments{
\item{instanceNames}{[required] The names for your new instances.}

\item{attachedDiskMapping}{An object containing information about one or more disk mappings.}

\item{availabilityZone}{[required] The Availability Zone where you want to create your instances. Use the
following formatting: \verb{us-east-2a} (case sensitive). You can get a list
of Availability Zones by using the \href{https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html}{get regions}
operation. Be sure to add the \verb{include Availability Zones} parameter to
your request.}

\item{instanceSnapshotName}{The name of the instance snapshot on which you are basing your new
instances. Use the get instance snapshots operation to return
information about your existing snapshots.

Constraint:
\itemize{
\item This parameter cannot be defined together with the
\verb{source instance name} parameter. The \verb{instance snapshot name} and
\verb{source instance name} parameters are mutually exclusive.
}}

\item{bundleId}{[required] The bundle of specification information for your virtual private server
(or \emph{instance}), including the pricing plan (e.g., \code{micro_1_0}).}

\item{userData}{You can create a launch script that configures a server with additional
user data. For example, \verb{apt-get -y update}.

Depending on the machine image you choose, the command to get software
on your instance varies. Amazon Linux and CentOS use \code{yum}, Debian and
Ubuntu use \code{apt-get}, and FreeBSD uses \code{pkg}. For a complete list, see
the Dev Guide.}

\item{keyPairName}{The name for your key pair.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{TagResource} action to tag a resource after it's created.}

\item{addOns}{An array of objects representing the add-ons to enable for the new
instance.}

\item{sourceInstanceName}{The name of the source instance from which the source automatic snapshot
was created.

Constraints:
\itemize{
\item This parameter cannot be defined together with the
\verb{instance snapshot name} parameter. The \verb{source instance name} and
\verb{instance snapshot name} parameters are mutually exclusive.
\item Define this parameter only when creating a new instance from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}

\item{restoreDate}{The date of the automatic snapshot to use for the new instance. Use the
\verb{get auto snapshots} operation to identify the dates of the available
automatic snapshots.

Constraints:
\itemize{
\item Must be specified in \code{YYYY-MM-DD} format.
\item This parameter cannot be defined together with the
\verb{use latest restorable auto snapshot} parameter. The \verb{restore date}
and \verb{use latest restorable auto snapshot} parameters are mutually
exclusive.
\item Define this parameter only when creating a new instance from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}

\item{useLatestRestorableAutoSnapshot}{A Boolean value to indicate whether to use the latest available
automatic snapshot.

Constraints:
\itemize{
\item This parameter cannot be defined together with the \verb{restore date}
parameter. The \verb{use latest restorable auto snapshot} and
\verb{restore date} parameters are mutually exclusive.
\item Define this parameter only when creating a new instance from an
automatic snapshot. For more information, see the Lightsail Dev
Guide.
}}
}
\description{
Creates one or more new instances from a manual or automatic snapshot of
an instance.

The \verb{create instances from snapshot} operation supports tag-based access
control via request tags and resource tags applied to the resource
identified by \verb{instance snapshot name}. For more information, see the
Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_instances_from_snapshot(
  instanceNames = list(
    "string"
  ),
  attachedDiskMapping = list(
    list(
      list(
        originalDiskPath = "string",
        newDiskName = "string"
      )
    )
  ),
  availabilityZone = "string",
  instanceSnapshotName = "string",
  bundleId = "string",
  userData = "string",
  keyPairName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  addOns = list(
    list(
      addOnType = "AutoSnapshot",
      autoSnapshotAddOnRequest = list(
        snapshotTimeOfDay = "string"
      )
    )
  ),
  sourceInstanceName = "string",
  restoreDate = "string",
  useLatestRestorableAutoSnapshot = TRUE|FALSE
)
}
}

\keyword{internal}
