% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_disk}
\alias{lightsail_create_disk}
\title{Creates a block storage disk that can be attached to an Amazon Lightsail
instance in the same Availability Zone (e}
\usage{
lightsail_create_disk(diskName, availabilityZone, sizeInGb, tags,
  addOns)
}
\arguments{
\item{diskName}{[required] The unique Lightsail disk name (e.g., \code{my-disk}).}

\item{availabilityZone}{[required] The Availability Zone where you want to create the disk (e.g.,
\verb{us-east-2a}). Use the same Availability Zone as the Lightsail instance
to which you want to attach the disk.

Use the \verb{get regions} operation to list the Availability Zones where
Lightsail is currently available.}

\item{sizeInGb}{[required] The size of the disk in GB (e.g., \code{32}).}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{TagResource} action to tag a resource after it's created.}

\item{addOns}{An array of objects that represent the add-ons to enable for the new
disk.}
}
\description{
Creates a block storage disk that can be attached to an Amazon Lightsail
instance in the same Availability Zone (e.g., \verb{us-east-2a}).

The \verb{create disk} operation supports tag-based access control via
request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_disk(
  diskName = "string",
  availabilityZone = "string",
  sizeInGb = 123,
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  addOns = list(
    list(
      addOnType = "AutoSnapshot",
      autoSnapshotAddOnRequest = list(
        snapshotTimeOfDay = "string"
      )
    )
  )
)
}
}

\keyword{internal}
