% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpc_endpoints}
\alias{ec2_delete_vpc_endpoints}
\title{Deletes one or more specified VPC endpoints}
\usage{
ec2_delete_vpc_endpoints(DryRun, VpcEndpointIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointIds}{[required] One or more VPC endpoint IDs.}
}
\description{
Deletes one or more specified VPC endpoints. Deleting a gateway endpoint
also deletes the endpoint routes in the route tables that were
associated with the endpoint. Deleting an interface endpoint or a
Gateway Load Balancer endpoint deletes the endpoint network interfaces.
Gateway Load Balancer endpoints can only be deleted if the routes that
are associated with the endpoint are deleted.
}
\section{Request syntax}{
\preformatted{svc$delete_vpc_endpoints(
  DryRun = TRUE|FALSE,
  VpcEndpointIds = list(
    "string"
  )
)
}
}

\keyword{internal}
