# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Elastic Kubernetes Service
#'
#' @description
#' Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that
#' makes it easy for you to run Kubernetes on AWS without needing to stand
#' up or maintain your own Kubernetes control plane. Kubernetes is an
#' open-source system for automating the deployment, scaling, and
#' management of containerized applications.
#' 
#' Amazon EKS runs up-to-date versions of the open-source Kubernetes
#' software, so you can use all the existing plugins and tooling from the
#' Kubernetes community. Applications running on Amazon EKS are fully
#' compatible with applications running on any standard Kubernetes
#' environment, whether running in on-premises data centers or public
#' clouds. This means that you can easily migrate any standard Kubernetes
#' application to Amazon EKS without any code modification required.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- eks(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- eks()
#' # The following example creates an Amazon EKS cluster called prod.
#' svc$create_cluster(
#'   version = "1.10",
#'   name = "prod",
#'   clientRequestToken = "1d2129a1-3d38-460a-9756-e5b91fddb951",
#'   resourcesVpcConfig = list(
#'     securityGroupIds = list(
#'       "sg-6979fe18"
#'     ),
#'     subnetIds = list(
#'       "subnet-6782e71e",
#'       "subnet-e7e761ac"
#'     )
#'   ),
#'   roleArn = "arn:aws:iam::012345678910:role/eks-service-role-AWSServiceRoleForAmazonEKS-J7ON..."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=eks_create_addon]{create_addon} \tab Creates an Amazon EKS add-on\cr
#'  \link[=eks_create_cluster]{create_cluster} \tab Creates an Amazon EKS control plane\cr
#'  \link[=eks_create_fargate_profile]{create_fargate_profile} \tab Creates an AWS Fargate profile for your Amazon EKS cluster\cr
#'  \link[=eks_create_nodegroup]{create_nodegroup} \tab Creates a managed worker node group for an Amazon EKS cluster\cr
#'  \link[=eks_delete_addon]{delete_addon} \tab Delete an Amazon EKS add-on\cr
#'  \link[=eks_delete_cluster]{delete_cluster} \tab Deletes the Amazon EKS cluster control plane\cr
#'  \link[=eks_delete_fargate_profile]{delete_fargate_profile} \tab Deletes an AWS Fargate profile\cr
#'  \link[=eks_delete_nodegroup]{delete_nodegroup} \tab Deletes an Amazon EKS node group for a cluster\cr
#'  \link[=eks_describe_addon]{describe_addon} \tab Describes an Amazon EKS add-on\cr
#'  \link[=eks_describe_addon_versions]{describe_addon_versions} \tab Describes the Kubernetes versions that the add-on can be used with\cr
#'  \link[=eks_describe_cluster]{describe_cluster} \tab Returns descriptive information about an Amazon EKS cluster\cr
#'  \link[=eks_describe_fargate_profile]{describe_fargate_profile} \tab Returns descriptive information about an AWS Fargate profile\cr
#'  \link[=eks_describe_nodegroup]{describe_nodegroup} \tab Returns descriptive information about an Amazon EKS node group\cr
#'  \link[=eks_describe_update]{describe_update} \tab Returns descriptive information about an update against your Amazon EKS cluster or associated managed node group\cr
#'  \link[=eks_list_addons]{list_addons} \tab Lists the available add-ons\cr
#'  \link[=eks_list_clusters]{list_clusters} \tab Lists the Amazon EKS clusters in your AWS account in the specified Region\cr
#'  \link[=eks_list_fargate_profiles]{list_fargate_profiles} \tab Lists the AWS Fargate profiles associated with the specified cluster in your AWS account in the specified Region\cr
#'  \link[=eks_list_nodegroups]{list_nodegroups} \tab Lists the Amazon EKS managed node groups associated with the specified cluster in your AWS account in the specified Region\cr
#'  \link[=eks_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an Amazon EKS resource\cr
#'  \link[=eks_list_updates]{list_updates} \tab Lists the updates associated with an Amazon EKS cluster or managed node group in your AWS account, in the specified Region\cr
#'  \link[=eks_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
#'  \link[=eks_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
#'  \link[=eks_update_addon]{update_addon} \tab Updates an Amazon EKS add-on\cr
#'  \link[=eks_update_cluster_config]{update_cluster_config} \tab Updates an Amazon EKS cluster configuration\cr
#'  \link[=eks_update_cluster_version]{update_cluster_version} \tab Updates an Amazon EKS cluster to the specified Kubernetes version\cr
#'  \link[=eks_update_nodegroup_config]{update_nodegroup_config} \tab Updates an Amazon EKS managed node group configuration\cr
#'  \link[=eks_update_nodegroup_version]{update_nodegroup_version} \tab Updates the Kubernetes version or AMI version of an Amazon EKS managed node group
#' }
#'
#' @rdname eks
#' @export
eks <- function(config = list()) {
  svc <- .eks$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.eks <- list()

.eks$operations <- list()

.eks$metadata <- list(
  service_name = "eks",
  endpoints = list("*" = list(endpoint = "eks.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "eks.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "eks.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "eks.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "EKS",
  api_version = "2017-11-01",
  signing_name = "eks",
  json_version = "1.1",
  target_prefix = ""
)

.eks$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.eks$metadata, handlers, config)
}
