% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_export_snapshot}
\alias{lightsail_export_snapshot}
\title{Exports an Amazon Lightsail instance or block storage disk snapshot to
Amazon Elastic Compute Cloud (Amazon EC2)}
\usage{
lightsail_export_snapshot(sourceSnapshotName)
}
\arguments{
\item{sourceSnapshotName}{[required] The name of the instance or disk snapshot to be exported to Amazon EC2.}
}
\description{
Exports an Amazon Lightsail instance or block storage disk snapshot to
Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an
export snapshot record that can be used with the
\code{create cloud formation stack} operation to create new Amazon EC2
instances.
}
\details{
Exported instance snapshots appear in Amazon EC2 as Amazon Machine
Images (AMIs), and the instance system disk appears as an Amazon Elastic
Block Store (Amazon EBS) volume. Exported disk snapshots appear in
Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same
Amazon Web Services Region in Amazon EC2 as the source Lightsail
snapshot.

The \code{export snapshot} operation supports tag-based access control via
resource tags applied to the resource identified by sourceSnapshotName.
For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.

Use the \code{get instance snapshots} or \code{get disk snapshots} operations to
get a list of snapshots that you can export to Amazon EC2.
}
\section{Request syntax}{
\preformatted{svc$export_snapshot(
  sourceSnapshotName = "string"
)
}
}

\keyword{internal}
