% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_reserved_instances_offering}
\alias{ec2_purchase_reserved_instances_offering}
\title{Purchases a Reserved Instance for use with your account}
\usage{
ec2_purchase_reserved_instances_offering(InstanceCount,
  ReservedInstancesOfferingId, DryRun, LimitPrice)
}
\arguments{
\item{InstanceCount}{[required] The number of Reserved Instances to purchase.}

\item{ReservedInstancesOfferingId}{[required] The ID of the Reserved Instance offering to purchase.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LimitPrice}{Specified for Reserved Instance Marketplace offerings to limit the total
order and ensure that the Reserved Instances are not purchased at
unexpected prices.}
}
\description{
Purchases a Reserved Instance for use with your account. With Reserved
Instances, you pay a lower hourly rate compared to On-Demand instance
pricing.
}
\details{
Use DescribeReservedInstancesOfferings to get a list of Reserved
Instance offerings that match your specifications. After you've
purchased a Reserved Instance, you can check for your new Reserved
Instance with DescribeReservedInstances.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html}{Reserved Instances}
and \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html}{Reserved Instance Marketplace}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$purchase_reserved_instances_offering(
  InstanceCount = 123,
  ReservedInstancesOfferingId = "string",
  DryRun = TRUE|FALSE,
  LimitPrice = list(
    Amount = 123.0,
    CurrencyCode = "USD"
  )
)
}
}

\keyword{internal}
