% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_create_map}
\alias{locationservice_create_map}
\title{Creates a map resource in your Amazon Web Services account, which
provides map tiles of different styles sourced from global location data
providers}
\usage{
locationservice_create_map(
  Configuration,
  Description = NULL,
  MapName,
  PricingPlan = NULL,
  Tags = NULL
)
}
\arguments{
\item{Configuration}{[required] Specifies the \code{MapConfiguration}, including the map style, for the map
resource that you create. The map style defines the look of maps and the
data provider for your map resource.}

\item{Description}{An optional description for the map resource.}

\item{MapName}{[required] The name for the map resource.

Requirements:
\itemize{
\item Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
(-), periods (.), and underscores (_).
\item Must be a unique map resource name.
\item No spaces allowed. For example, \code{ExampleMap}.
}}

\item{PricingPlan}{No longer used. If included, the only allowed value is
\code{RequestBasedUsage}.}

\item{Tags}{Applies one or more tags to the map resource. A tag is a key-value pair
helps manage, identify, search, and filter your resources by labelling
them.

Format: \code{"key" : "value"}

Restrictions:
\itemize{
\item Maximum 50 tags per resource
\item Each resource tag must be unique with a maximum of one value.
\item Maximum key length: 128 Unicode characters in UTF-8
\item Maximum value length: 256 Unicode characters in UTF-8
\item Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
characters: + - = . _ : / @.
\item Cannot use "aws:" as a prefix for a key.
}}
}
\description{
Creates a map resource in your Amazon Web Services account, which provides map tiles of different styles sourced from global location data providers.

See \url{https://www.paws-r-sdk.com/docs/locationservice_create_map/} for full documentation.
}
\keyword{internal}
