% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_update_user}
\alias{mq_update_user}
\title{Updates the information for an ActiveMQ user}
\usage{
mq_update_user(
  BrokerId,
  ConsoleAccess = NULL,
  Groups = NULL,
  Password = NULL,
  Username,
  ReplicationUser = NULL
)
}
\arguments{
\item{BrokerId}{[required] The unique ID that Amazon MQ generates for the broker.}

\item{ConsoleAccess}{Enables access to the the ActiveMQ Web Console for the ActiveMQ user.}

\item{Groups}{The list of groups (20 maximum) to which the ActiveMQ user belongs. This
value can contain only alphanumeric characters, dashes, periods,
underscores, and tildes (- . _ ~). This value must be 2-100 characters
long.}

\item{Password}{The password of the user. This value must be at least 12 characters
long, must contain at least 4 unique characters, and must not contain
commas, colons, or equal signs (,:=).}

\item{Username}{[required] The username of the ActiveMQ user. This value can contain only
alphanumeric characters, dashes, periods, underscores, and tildes (- .
_ ~). This value must be 2-100 characters long.}

\item{ReplicationUser}{Defines whether the user is intended for data replication.}
}
\description{
Updates the information for an ActiveMQ user.

See \url{https://www.paws-r-sdk.com/docs/mq_update_user/} for full documentation.
}
\keyword{internal}
