% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_register_activity_type}
\alias{swf_register_activity_type}
\title{Registers a new activity type along with its configuration settings in
the specified domain}
\usage{
swf_register_activity_type(domain, name, version, description,
  defaultTaskStartToCloseTimeout, defaultTaskHeartbeatTimeout,
  defaultTaskList, defaultTaskPriority, defaultTaskScheduleToStartTimeout,
  defaultTaskScheduleToCloseTimeout)
}
\arguments{
\item{domain}{[required] The name of the domain in which this activity is to be registered.}

\item{name}{[required] The name of the activity type within the domain.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{\\u0000-\\u001f} | \verb{\\u007f-\\u009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{version}{[required] The version of the activity type.

The activity type consists of the name and version, the combination of
which must be unique within the domain.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{\\u0000-\\u001f} | \verb{\\u007f-\\u009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{description}{A textual description of the activity type.}

\item{defaultTaskStartToCloseTimeout}{If set, specifies the default maximum duration that a worker can take to
process tasks of this activity type. This default can be overridden when
scheduling an activity task using the \code{ScheduleActivityTask} Decision.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.}

\item{defaultTaskHeartbeatTimeout}{If set, specifies the default maximum time before which a worker
processing a task of this type must report progress by calling
\code{\link[=swf_record_activity_task_heartbeat]{record_activity_task_heartbeat}}.
If the timeout is exceeded, the activity task is automatically timed
out. This default can be overridden when scheduling an activity task
using the \code{ScheduleActivityTask} Decision. If the activity worker
subsequently attempts to record a heartbeat or returns a result, the
activity worker receives an \code{UnknownResource} fault. In this case,
Amazon SWF no longer considers the activity task to be valid; the
activity worker should clean up the activity task.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.}

\item{defaultTaskList}{If set, specifies the default task list to use for scheduling tasks of
this activity type. This default task list is used if a task list isn't
provided when a task is scheduled through the \code{ScheduleActivityTask}
Decision.}

\item{defaultTaskPriority}{The default task priority to assign to the activity type. If not
assigned, then \code{0} is used. Valid values are integers that range from
Java's \code{Integer.MIN_VALUE} (-2147483648) to \code{Integer.MAX_VALUE}
(2147483647). Higher numbers indicate higher priority.

For more information about setting task priority, see \href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html}{Setting Task Priority}
in the \emph{in the \emph{Amazon SWF Developer Guide}.}.}

\item{defaultTaskScheduleToStartTimeout}{If set, specifies the default maximum duration that a task of this
activity type can wait before being assigned to a worker. This default
can be overridden when scheduling an activity task using the
\code{ScheduleActivityTask} Decision.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.}

\item{defaultTaskScheduleToCloseTimeout}{If set, specifies the default maximum duration for a task of this
activity type. This default can be overridden when scheduling an
activity task using the \code{ScheduleActivityTask} Decision.

The duration is specified in seconds, an integer greater than or equal
to \code{0}. You can use \code{NONE} to specify unlimited duration.}
}
\value{
An empty list.
}
\description{
Registers a new \emph{activity type} along with its configuration settings in
the specified domain.

A \code{TypeAlreadyExists} fault is returned if the type already exists in
the domain. You cannot change any configuration settings of the type
after its registration, and it must be registered as a new version.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the following parameters by using a \code{Condition} element
with the appropriate keys.
\itemize{
\item \code{defaultTaskList.name}: String constraint. The key is
\code{swf:defaultTaskList.name}.
\item \code{name}: String constraint. The key is \code{swf:name}.
\item \code{version}: String constraint. The key is \code{swf:version}.
}
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$register_activity_type(
  domain = "string",
  name = "string",
  version = "string",
  description = "string",
  defaultTaskStartToCloseTimeout = "string",
  defaultTaskHeartbeatTimeout = "string",
  defaultTaskList = list(
    name = "string"
  ),
  defaultTaskPriority = "string",
  defaultTaskScheduleToStartTimeout = "string",
  defaultTaskScheduleToCloseTimeout = "string"
)
}
}

\keyword{internal}
