% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_replays}
\alias{eventbridge_list_replays}
\title{Lists your replays}
\usage{
eventbridge_list_replays(NamePrefix, State, EventSourceArn, NextToken,
  Limit)
}
\arguments{
\item{NamePrefix}{A name prefix to filter the replays returned. Only replays with name
that match the prefix are returned.}

\item{State}{The state of the replay.}

\item{EventSourceArn}{The ARN of the event source associated with the replay.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{The maximum number of replays to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Replays = list(
    list(
      ReplayName = "string",
      EventSourceArn = "string",
      State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
      StateReason = "string",
      EventStartTime = as.POSIXct(
        "2015-01-01"
      ),
      EventEndTime = as.POSIXct(
        "2015-01-01"
      ),
      EventLastReplayedTime = as.POSIXct(
        "2015-01-01"
      ),
      ReplayStartTime = as.POSIXct(
        "2015-01-01"
      ),
      ReplayEndTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists your replays. You can either list all the replays or you can
provide a prefix to match to the replay names. Filter parameters are
exclusive.
}
\section{Request syntax}{
\preformatted{svc$list_replays(
  NamePrefix = "string",
  State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
  EventSourceArn = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
