% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_list_event_sources}
\alias{eventbridge_list_event_sources}
\title{You can use this to see all the partner event sources that have been
shared with your AWS account}
\usage{
eventbridge_list_event_sources(NamePrefix, NextToken, Limit)
}
\arguments{
\item{NamePrefix}{Specifying this limits the results to only those partner event sources
with names that start with the specified prefix.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{Specifying this limits the number of results returned by this operation.
The operation also returns a NextToken which you can use in a subsequent
operation to retrieve the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventSources = list(
    list(
      Arn = "string",
      CreatedBy = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      ExpirationTime = as.POSIXct(
        "2015-01-01"
      ),
      Name = "string",
      State = "PENDING"|"ACTIVE"|"DELETED"
    )
  ),
  NextToken = "string"
)
}
}
\description{
You can use this to see all the partner event sources that have been
shared with your AWS account. For more information about partner event
sources, see \code{\link[=eventbridge_create_event_bus]{create_event_bus}}.
}
\section{Request syntax}{
\preformatted{svc$list_event_sources(
  NamePrefix = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
