% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_describe_stream_consumer}
\alias{kinesis_describe_stream_consumer}
\title{To get the description of a registered consumer, provide the ARN of the
consumer}
\usage{
kinesis_describe_stream_consumer(
  StreamARN = NULL,
  ConsumerName = NULL,
  ConsumerARN = NULL
)
}
\arguments{
\item{StreamARN}{The ARN of the Kinesis data stream that the consumer is registered with.
For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#arn-syntax-kinesis-streams}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}.}

\item{ConsumerName}{The name that you gave to the consumer.}

\item{ConsumerARN}{The ARN returned by Kinesis Data Streams when you registered the
consumer.}
}
\description{
To get the description of a registered consumer, provide the ARN of the consumer. Alternatively, you can provide the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the consumer that you want to describe, you can use the \code{\link[=kinesis_list_stream_consumers]{list_stream_consumers}} operation to get a list of the descriptions of all the consumers that are currently registered with a given data stream.

See \url{https://www.paws-r-sdk.com/docs/kinesis_describe_stream_consumer/} for full documentation.
}
\keyword{internal}
