% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_create_cluster}
\alias{kafka_create_cluster}
\title{Creates a new MSK cluster}
\usage{
kafka_create_cluster(
  BrokerNodeGroupInfo,
  ClientAuthentication = NULL,
  ClusterName,
  ConfigurationInfo = NULL,
  EncryptionInfo = NULL,
  EnhancedMonitoring = NULL,
  OpenMonitoring = NULL,
  KafkaVersion,
  LoggingInfo = NULL,
  NumberOfBrokerNodes,
  Tags = NULL,
  StorageMode = NULL
)
}
\arguments{
\item{BrokerNodeGroupInfo}{[required] Information about the broker nodes in the cluster.}

\item{ClientAuthentication}{Includes all client authentication related information.}

\item{ClusterName}{[required] The name of the cluster.}

\item{ConfigurationInfo}{Represents the configuration that you want MSK to use for the brokers in
a cluster.}

\item{EncryptionInfo}{Includes all encryption-related information.}

\item{EnhancedMonitoring}{Specifies the level of monitoring for the MSK cluster. The possible
values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and
PER_TOPIC_PER_PARTITION.}

\item{OpenMonitoring}{The settings for open monitoring.}

\item{KafkaVersion}{[required] The version of Apache Kafka.}

\item{LoggingInfo}{}

\item{NumberOfBrokerNodes}{[required] The number of broker nodes in the cluster.}

\item{Tags}{Create tags when creating the cluster.}

\item{StorageMode}{This controls storage mode for supported storage tiers.}
}
\description{
Creates a new MSK cluster.

See \url{https://www.paws-r-sdk.com/docs/kafka_create_cluster/} for full documentation.
}
\keyword{internal}
