% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_unfiltered_partition_metadata}
\alias{glue_get_unfiltered_partition_metadata}
\title{Retrieves partition metadata from the Data Catalog that contains
unfiltered metadata}
\usage{
glue_get_unfiltered_partition_metadata(
  Region = NULL,
  CatalogId,
  DatabaseName,
  TableName,
  PartitionValues,
  AuditContext = NULL,
  SupportedPermissionTypes,
  QuerySessionContext = NULL
)
}
\arguments{
\item{Region}{Specified only if the base tables belong to a different Amazon Web
Services Region.}

\item{CatalogId}{[required] The catalog ID where the partition resides.}

\item{DatabaseName}{[required] (Required) Specifies the name of a database that contains the partition.}

\item{TableName}{[required] (Required) Specifies the name of a table that contains the partition.}

\item{PartitionValues}{[required] (Required) A list of partition key values.}

\item{AuditContext}{A structure containing Lake Formation audit context information.}

\item{SupportedPermissionTypes}{[required] (Required) A list of supported permission types.}

\item{QuerySessionContext}{A structure used as a protocol between query engines and Lake Formation
or Glue. Contains both a Lake Formation generated authorization
identifier and information from the request's authorization context.}
}
\description{
Retrieves partition metadata from the Data Catalog that contains unfiltered metadata.

See \url{https://www.paws-r-sdk.com/docs/glue_get_unfiltered_partition_metadata/} for full documentation.
}
\keyword{internal}
