% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_list_instances}
\alias{emr_list_instances}
\title{Provides information for all active Amazon EC2 instances and Amazon EC2
instances terminated in the last 30 days, up to a maximum of 2,000}
\usage{
emr_list_instances(
  ClusterId,
  InstanceGroupId = NULL,
  InstanceGroupTypes = NULL,
  InstanceFleetId = NULL,
  InstanceFleetType = NULL,
  InstanceStates = NULL,
  Marker = NULL
)
}
\arguments{
\item{ClusterId}{[required] The identifier of the cluster for which to list the instances.}

\item{InstanceGroupId}{The identifier of the instance group for which to list the instances.}

\item{InstanceGroupTypes}{The type of instance group for which to list the instances.}

\item{InstanceFleetId}{The unique identifier of the instance fleet.}

\item{InstanceFleetType}{The node type of the instance fleet. For example MASTER, CORE, or TASK.}

\item{InstanceStates}{A list of instance states that will filter the instances returned with
this request.}

\item{Marker}{The pagination token that indicates the next set of results to retrieve.}
}
\description{
Provides information for all active Amazon EC2 instances and Amazon EC2 instances terminated in the last 30 days, up to a maximum of 2,000. Amazon EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.

See \url{https://www.paws-r-sdk.com/docs/emr_list_instances/} for full documentation.
}
\keyword{internal}
