% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_data_source}
\alias{quicksight_create_data_source}
\title{Creates a data source}
\usage{
quicksight_create_data_source(
  AwsAccountId,
  DataSourceId,
  Name,
  Type,
  DataSourceParameters = NULL,
  Credentials = NULL,
  Permissions = NULL,
  VpcConnectionProperties = NULL,
  SslProperties = NULL,
  Tags = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID.}

\item{DataSourceId}{[required] An ID for the data source. This ID is unique per Amazon Web Services
Region for each Amazon Web Services account.}

\item{Name}{[required] A display name for the data source.}

\item{Type}{[required] The type of the data source. To return a list of all data sources, use
\code{\link[=quicksight_list_data_sources]{list_data_sources}}.

Use \code{AMAZON_ELASTICSEARCH} for Amazon OpenSearch Service.}

\item{DataSourceParameters}{The parameters that Amazon QuickSight uses to connect to your underlying
source.}

\item{Credentials}{The credentials Amazon QuickSight that uses to connect to your
underlying source. Currently, only credentials based on user name and
password are supported.}

\item{Permissions}{A list of resource permissions on the data source.}

\item{VpcConnectionProperties}{Use this parameter only when you want Amazon QuickSight to use a VPC
connection when connecting to your underlying source.}

\item{SslProperties}{Secure Socket Layer (SSL) properties that apply when Amazon QuickSight
connects to your underlying source.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the data source.}
}
\description{
Creates a data source.

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_data_source/} for full documentation.
}
\keyword{internal}
