% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_data_source}
\alias{quicksight_update_data_source}
\title{Updates a data source}
\usage{
quicksight_update_data_source(
  AwsAccountId,
  DataSourceId,
  Name,
  DataSourceParameters = NULL,
  Credentials = NULL,
  VpcConnectionProperties = NULL,
  SslProperties = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID.}

\item{DataSourceId}{[required] The ID of the data source. This ID is unique per Amazon Web Services
Region for each Amazon Web Services account.}

\item{Name}{[required] A display name for the data source.}

\item{DataSourceParameters}{The parameters that Amazon QuickSight uses to connect to your underlying
source.}

\item{Credentials}{The credentials that Amazon QuickSight that uses to connect to your
underlying source. Currently, only credentials based on user name and
password are supported.}

\item{VpcConnectionProperties}{Use this parameter only when you want Amazon QuickSight to use a VPC
connection when connecting to your underlying source.}

\item{SslProperties}{Secure Socket Layer (SSL) properties that apply when Amazon QuickSight
connects to your underlying source.}
}
\description{
Updates a data source.

See \url{https://paws-r.github.io/docs/quicksight/update_data_source.html} for full documentation.
}
\keyword{internal}
