% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_put_block_public_access_configuration}
\alias{emr_put_block_public_access_configuration}
\title{Creates or updates an Amazon EMR block public access configuration for
your Amazon Web Services account in the current Region}
\usage{
emr_put_block_public_access_configuration(BlockPublicAccessConfiguration)
}
\arguments{
\item{BlockPublicAccessConfiguration}{[required] A configuration for Amazon EMR block public access. The configuration
applies to all clusters created in your account for the current Region.
The configuration specifies whether block public access is enabled. If
block public access is enabled, security groups associated with the
cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
::/0 on a port, unless the port is specified as an exception using
\code{PermittedPublicSecurityGroupRuleRanges} in the
\code{BlockPublicAccessConfiguration}. By default, Port 22 (SSH) is an
exception, and public access is allowed on this port. You can change
this by updating \code{BlockPublicSecurityGroupRules} to remove the
exception.

For accounts that created clusters in a Region before November 25, 2019,
block public access is disabled by default in that Region. To use this
feature, you must manually enable and configure it. For accounts that
did not create an EMR cluster in a Region before this date, block public
access is enabled by default in that Region.}
}
\description{
Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see \href{https://docs.aws.amazon.com/emr/latest/ManagementGuide/}{Configure Block Public Access for Amazon EMR} in the \emph{Amazon EMR Management Guide}.

See \url{https://paws-r.github.io/docs/emr/put_block_public_access_configuration.html} for full documentation.
}
\keyword{internal}
