# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include emr_service.R
NULL

#' Adds an instance fleet to a running cluster
#'
#' @description
#' Adds an instance fleet to a running cluster.
#'
#' See [https://paws-r.github.io/docs/emr/add_instance_fleet.html](https://paws-r.github.io/docs/emr/add_instance_fleet.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param InstanceFleet &#91;required&#93; Specifies the configuration of the instance fleet.
#'
#' @keywords internal
#'
#' @rdname emr_add_instance_fleet
emr_add_instance_fleet <- function(ClusterId, InstanceFleet) {
  op <- new_operation(
    name = "AddInstanceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_instance_fleet_input(ClusterId = ClusterId, InstanceFleet = InstanceFleet)
  output <- .emr$add_instance_fleet_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_instance_fleet <- emr_add_instance_fleet

#' Adds one or more instance groups to a running cluster
#'
#' @description
#' Adds one or more instance groups to a running cluster.
#'
#' See [https://paws-r.github.io/docs/emr/add_instance_groups.html](https://paws-r.github.io/docs/emr/add_instance_groups.html) for full documentation.
#'
#' @param InstanceGroups &#91;required&#93; Instance groups to add.
#' @param JobFlowId &#91;required&#93; Job flow in which to add the instance groups.
#'
#' @keywords internal
#'
#' @rdname emr_add_instance_groups
emr_add_instance_groups <- function(InstanceGroups, JobFlowId) {
  op <- new_operation(
    name = "AddInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_instance_groups_input(InstanceGroups = InstanceGroups, JobFlowId = JobFlowId)
  output <- .emr$add_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_instance_groups <- emr_add_instance_groups

#' AddJobFlowSteps adds new steps to a running cluster
#'
#' @description
#' AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.
#'
#' See [https://paws-r.github.io/docs/emr/add_job_flow_steps.html](https://paws-r.github.io/docs/emr/add_job_flow_steps.html) for full documentation.
#'
#' @param JobFlowId &#91;required&#93; A string that uniquely identifies the job flow. This identifier is
#' returned by [`run_job_flow`][emr_run_job_flow] and can also be obtained
#' from [`list_clusters`][emr_list_clusters].
#' @param Steps &#91;required&#93; A list of StepConfig to be executed by the job flow.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the runtime role for a step on the
#' cluster. The runtime role can be a cross-account IAM role. The runtime
#' role ARN is a combination of account ID, role name, and role type using
#' the following format: `arn:partition:service:region:account:resource`.
#' 
#' For example, `arn:aws:iam::1234567890:role/ReadOnly` is a correctly
#' formatted runtime role ARN.
#'
#' @keywords internal
#'
#' @rdname emr_add_job_flow_steps
emr_add_job_flow_steps <- function(JobFlowId, Steps, ExecutionRoleArn = NULL) {
  op <- new_operation(
    name = "AddJobFlowSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_job_flow_steps_input(JobFlowId = JobFlowId, Steps = Steps, ExecutionRoleArn = ExecutionRoleArn)
  output <- .emr$add_job_flow_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_job_flow_steps <- emr_add_job_flow_steps

#' Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR
#' Studio
#'
#' @description
#' Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
#'
#' See [https://paws-r.github.io/docs/emr/add_tags.html](https://paws-r.github.io/docs/emr/add_tags.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The Amazon EMR resource identifier to which tags will be added. For
#' example, a cluster identifier or an Amazon EMR Studio ID.
#' @param Tags &#91;required&#93; A list of tags to associate with a resource. Tags are user-defined
#' key-value pairs that consist of a required key string with a maximum of
#' 128 characters, and an optional value string with a maximum of 256
#' characters.
#'
#' @keywords internal
#'
#' @rdname emr_add_tags
emr_add_tags <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$add_tags_input(ResourceId = ResourceId, Tags = Tags)
  output <- .emr$add_tags_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$add_tags <- emr_add_tags

#' Cancels a pending step or steps in a running cluster
#'
#' @description
#' Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a `PENDING` or `RUNNING` state. In earlier versions of Amazon EMR, you can only cancel steps that are in a `PENDING` state.
#'
#' See [https://paws-r.github.io/docs/emr/cancel_steps.html](https://paws-r.github.io/docs/emr/cancel_steps.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The `ClusterID` for the specified steps that will be canceled. Use
#' [`run_job_flow`][emr_run_job_flow] and
#' [`list_clusters`][emr_list_clusters] to get ClusterIDs.
#' @param StepIds &#91;required&#93; The list of `StepIDs` to cancel. Use [`list_steps`][emr_list_steps] to
#' get steps and their states for the specified cluster.
#' @param StepCancellationOption The option to choose to cancel `RUNNING` steps. By default, the value is
#' `SEND_INTERRUPT`.
#'
#' @keywords internal
#'
#' @rdname emr_cancel_steps
emr_cancel_steps <- function(ClusterId, StepIds, StepCancellationOption = NULL) {
  op <- new_operation(
    name = "CancelSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$cancel_steps_input(ClusterId = ClusterId, StepIds = StepIds, StepCancellationOption = StepCancellationOption)
  output <- .emr$cancel_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$cancel_steps <- emr_cancel_steps

#' Creates a security configuration, which is stored in the service and can
#' be specified when a cluster is created
#'
#' @description
#' Creates a security configuration, which is stored in the service and can be specified when a cluster is created.
#'
#' See [https://paws-r.github.io/docs/emr/create_security_configuration.html](https://paws-r.github.io/docs/emr/create_security_configuration.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#' @param SecurityConfiguration &#91;required&#93; The security configuration details in JSON format. For JSON parameters
#' and examples, see [Use Security Configurations to Set Up Cluster
#' Security](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html)
#' in the *Amazon EMR Management Guide*.
#'
#' @keywords internal
#'
#' @rdname emr_create_security_configuration
emr_create_security_configuration <- function(Name, SecurityConfiguration) {
  op <- new_operation(
    name = "CreateSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$create_security_configuration_input(Name = Name, SecurityConfiguration = SecurityConfiguration)
  output <- .emr$create_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$create_security_configuration <- emr_create_security_configuration

#' Creates a new Amazon EMR Studio
#'
#' @description
#' Creates a new Amazon EMR Studio.
#'
#' See [https://paws-r.github.io/docs/emr/create_studio.html](https://paws-r.github.io/docs/emr/create_studio.html) for full documentation.
#'
#' @param Name &#91;required&#93; A descriptive name for the Amazon EMR Studio.
#' @param Description A detailed description of the Amazon EMR Studio.
#' @param AuthMode &#91;required&#93; Specifies whether the Studio authenticates users using IAM or Amazon Web
#' Services SSO.
#' @param VpcId &#91;required&#93; The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate
#' with the Studio.
#' @param SubnetIds &#91;required&#93; A list of subnet IDs to associate with the Amazon EMR Studio. A Studio
#' can have a maximum of 5 subnets. The subnets must belong to the VPC
#' specified by `VpcId`. Studio users can create a Workspace in any of the
#' specified subnets.
#' @param ServiceRole &#91;required&#93; The IAM role that the Amazon EMR Studio assumes. The service role
#' provides a way for Amazon EMR Studio to interoperate with other Amazon
#' Web Services services.
#' @param UserRole The IAM user role that users and groups assume when logged in to an
#' Amazon EMR Studio. Only specify a `UserRole` when you use Amazon Web
#' Services SSO authentication. The permissions attached to the `UserRole`
#' can be scoped down for each user or group using session policies.
#' @param WorkspaceSecurityGroupId &#91;required&#93; The ID of the Amazon EMR Studio Workspace security group. The Workspace
#' security group allows outbound network traffic to resources in the
#' Engine security group, and it must be in the same VPC specified by
#' `VpcId`.
#' @param EngineSecurityGroupId &#91;required&#93; The ID of the Amazon EMR Studio Engine security group. The Engine
#' security group allows inbound network traffic from the Workspace
#' security group, and it must be in the same VPC specified by `VpcId`.
#' @param DefaultS3Location &#91;required&#93; The Amazon S3 location to back up Amazon EMR Studio Workspaces and
#' notebook files.
#' @param IdpAuthUrl The authentication endpoint of your identity provider (IdP). Specify
#' this value when you use IAM authentication and want to let federated
#' users log in to a Studio with the Studio URL and credentials from your
#' IdP. Amazon EMR Studio redirects users to this endpoint to enter
#' credentials.
#' @param IdpRelayStateParameterName The name that your identity provider (IdP) uses for its `RelayState`
#' parameter. For example, `RelayState` or `TargetSource`. Specify this
#' value when you use IAM authentication and want to let federated users
#' log in to a Studio using the Studio URL. The `RelayState` parameter
#' differs by IdP.
#' @param Tags A list of tags to associate with the Amazon EMR Studio. Tags are
#' user-defined key-value pairs that consist of a required key string with
#' a maximum of 128 characters, and an optional value string with a maximum
#' of 256 characters.
#'
#' @keywords internal
#'
#' @rdname emr_create_studio
emr_create_studio <- function(Name, Description = NULL, AuthMode, VpcId, SubnetIds, ServiceRole, UserRole = NULL, WorkspaceSecurityGroupId, EngineSecurityGroupId, DefaultS3Location, IdpAuthUrl = NULL, IdpRelayStateParameterName = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateStudio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$create_studio_input(Name = Name, Description = Description, AuthMode = AuthMode, VpcId = VpcId, SubnetIds = SubnetIds, ServiceRole = ServiceRole, UserRole = UserRole, WorkspaceSecurityGroupId = WorkspaceSecurityGroupId, EngineSecurityGroupId = EngineSecurityGroupId, DefaultS3Location = DefaultS3Location, IdpAuthUrl = IdpAuthUrl, IdpRelayStateParameterName = IdpRelayStateParameterName, Tags = Tags)
  output <- .emr$create_studio_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$create_studio <- emr_create_studio

#' Maps a user or group to the Amazon EMR Studio specified by StudioId, and
#' applies a session policy to refine Studio permissions for that user or
#' group
#'
#' @description
#' Maps a user or group to the Amazon EMR Studio specified by `StudioId`, and applies a session policy to refine Studio permissions for that user or group. Use [`create_studio_session_mapping`][emr_create_studio_session_mapping] to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see [Assign a user or group to your EMR Studio](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups).
#'
#' See [https://paws-r.github.io/docs/emr/create_studio_session_mapping.html](https://paws-r.github.io/docs/emr/create_studio_session_mapping.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio to which the user or group will be
#' mapped.
#' @param IdentityId The globally unique identifier (GUID) of the user or group from the
#' Amazon Web Services SSO Identity Store. For more information, see
#' [UserId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
#' and
#' [GroupId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified, but not both.
#' @param IdentityName The name of the user or group. For more information, see
#' [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
#' and
#' [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified, but not both.
#' @param IdentityType &#91;required&#93; Specifies whether the identity to map to the Amazon EMR Studio is a user
#' or a group.
#' @param SessionPolicyArn &#91;required&#93; The Amazon Resource Name (ARN) for the session policy that will be
#' applied to the user or group. You should specify the ARN for the session
#' policy that you want to apply, not the ARN of your user role. For more
#' information, see [Create an EMR Studio User Role with Session
#' Policies](https://docs.aws.amazon.com/emr/latest/ManagementGuide/).
#'
#' @keywords internal
#'
#' @rdname emr_create_studio_session_mapping
emr_create_studio_session_mapping <- function(StudioId, IdentityId = NULL, IdentityName = NULL, IdentityType, SessionPolicyArn) {
  op <- new_operation(
    name = "CreateStudioSessionMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$create_studio_session_mapping_input(StudioId = StudioId, IdentityId = IdentityId, IdentityName = IdentityName, IdentityType = IdentityType, SessionPolicyArn = SessionPolicyArn)
  output <- .emr$create_studio_session_mapping_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$create_studio_session_mapping <- emr_create_studio_session_mapping

#' Deletes a security configuration
#'
#' @description
#' Deletes a security configuration.
#'
#' See [https://paws-r.github.io/docs/emr/delete_security_configuration.html](https://paws-r.github.io/docs/emr/delete_security_configuration.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#'
#' @keywords internal
#'
#' @rdname emr_delete_security_configuration
emr_delete_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DeleteSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$delete_security_configuration_input(Name = Name)
  output <- .emr$delete_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$delete_security_configuration <- emr_delete_security_configuration

#' Removes an Amazon EMR Studio from the Studio metadata store
#'
#' @description
#' Removes an Amazon EMR Studio from the Studio metadata store.
#'
#' See [https://paws-r.github.io/docs/emr/delete_studio.html](https://paws-r.github.io/docs/emr/delete_studio.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio.
#'
#' @keywords internal
#'
#' @rdname emr_delete_studio
emr_delete_studio <- function(StudioId) {
  op <- new_operation(
    name = "DeleteStudio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$delete_studio_input(StudioId = StudioId)
  output <- .emr$delete_studio_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$delete_studio <- emr_delete_studio

#' Removes a user or group from an Amazon EMR Studio
#'
#' @description
#' Removes a user or group from an Amazon EMR Studio.
#'
#' See [https://paws-r.github.io/docs/emr/delete_studio_session_mapping.html](https://paws-r.github.io/docs/emr/delete_studio_session_mapping.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio.
#' @param IdentityId The globally unique identifier (GUID) of the user or group to remove
#' from the Amazon EMR Studio. For more information, see
#' [UserId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
#' and
#' [GroupId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityName The name of the user name or group to remove from the Amazon EMR Studio.
#' For more information, see
#' [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
#' and
#' [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
#' in the *Amazon Web Services SSO Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityType &#91;required&#93; Specifies whether the identity to delete from the Amazon EMR Studio is a
#' user or a group.
#'
#' @keywords internal
#'
#' @rdname emr_delete_studio_session_mapping
emr_delete_studio_session_mapping <- function(StudioId, IdentityId = NULL, IdentityName = NULL, IdentityType) {
  op <- new_operation(
    name = "DeleteStudioSessionMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$delete_studio_session_mapping_input(StudioId = StudioId, IdentityId = IdentityId, IdentityName = IdentityName, IdentityType = IdentityType)
  output <- .emr$delete_studio_session_mapping_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$delete_studio_session_mapping <- emr_delete_studio_session_mapping

#' Provides cluster-level details including status, hardware and software
#' configuration, VPC settings, and so on
#'
#' @description
#' Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.
#'
#' See [https://paws-r.github.io/docs/emr/describe_cluster.html](https://paws-r.github.io/docs/emr/describe_cluster.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster to describe.
#'
#' @keywords internal
#'
#' @rdname emr_describe_cluster
emr_describe_cluster <- function(ClusterId) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_cluster_input(ClusterId = ClusterId)
  output <- .emr$describe_cluster_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_cluster <- emr_describe_cluster

#' This API is no longer supported and will eventually be removed
#'
#' @description
#' This API is no longer supported and will eventually be removed. We recommend you use [`list_clusters`][emr_list_clusters], [`describe_cluster`][emr_describe_cluster], [`list_steps`][emr_list_steps], [`list_instance_groups`][emr_list_instance_groups] and [`list_bootstrap_actions`][emr_list_bootstrap_actions] instead.
#'
#' See [https://paws-r.github.io/docs/emr/describe_job_flows.html](https://paws-r.github.io/docs/emr/describe_job_flows.html) for full documentation.
#'
#' @param CreatedAfter Return only job flows created after this date and time.
#' @param CreatedBefore Return only job flows created before this date and time.
#' @param JobFlowIds Return only job flows whose job flow ID is contained in this list.
#' @param JobFlowStates Return only job flows whose state is contained in this list.
#'
#' @keywords internal
#'
#' @rdname emr_describe_job_flows
emr_describe_job_flows <- function(CreatedAfter = NULL, CreatedBefore = NULL, JobFlowIds = NULL, JobFlowStates = NULL) {
  op <- new_operation(
    name = "DescribeJobFlows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_job_flows_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, JobFlowIds = JobFlowIds, JobFlowStates = JobFlowStates)
  output <- .emr$describe_job_flows_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_job_flows <- emr_describe_job_flows

#' Provides details of a notebook execution
#'
#' @description
#' Provides details of a notebook execution.
#'
#' See [https://paws-r.github.io/docs/emr/describe_notebook_execution.html](https://paws-r.github.io/docs/emr/describe_notebook_execution.html) for full documentation.
#'
#' @param NotebookExecutionId &#91;required&#93; The unique identifier of the notebook execution.
#'
#' @keywords internal
#'
#' @rdname emr_describe_notebook_execution
emr_describe_notebook_execution <- function(NotebookExecutionId) {
  op <- new_operation(
    name = "DescribeNotebookExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_notebook_execution_input(NotebookExecutionId = NotebookExecutionId)
  output <- .emr$describe_notebook_execution_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_notebook_execution <- emr_describe_notebook_execution

#' Provides EMR release label details, such as releases available the
#' region where the API request is run, and the available applications for
#' a specific EMR release label
#'
#' @description
#' Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
#'
#' See [https://paws-r.github.io/docs/emr/describe_release_label.html](https://paws-r.github.io/docs/emr/describe_release_label.html) for full documentation.
#'
#' @param ReleaseLabel The target release label to be described.
#' @param NextToken The pagination token. Reserved for future use. Currently set to null.
#' @param MaxResults Reserved for future use. Currently set to null.
#'
#' @keywords internal
#'
#' @rdname emr_describe_release_label
emr_describe_release_label <- function(ReleaseLabel = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeReleaseLabel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_release_label_input(ReleaseLabel = ReleaseLabel, NextToken = NextToken, MaxResults = MaxResults)
  output <- .emr$describe_release_label_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_release_label <- emr_describe_release_label

#' Provides the details of a security configuration by returning the
#' configuration JSON
#'
#' @description
#' Provides the details of a security configuration by returning the configuration JSON.
#'
#' See [https://paws-r.github.io/docs/emr/describe_security_configuration.html](https://paws-r.github.io/docs/emr/describe_security_configuration.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the security configuration.
#'
#' @keywords internal
#'
#' @rdname emr_describe_security_configuration
emr_describe_security_configuration <- function(Name) {
  op <- new_operation(
    name = "DescribeSecurityConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_security_configuration_input(Name = Name)
  output <- .emr$describe_security_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_security_configuration <- emr_describe_security_configuration

#' Provides more detail about the cluster step
#'
#' @description
#' Provides more detail about the cluster step.
#'
#' See [https://paws-r.github.io/docs/emr/describe_step.html](https://paws-r.github.io/docs/emr/describe_step.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster with steps to describe.
#' @param StepId &#91;required&#93; The identifier of the step to describe.
#'
#' @keywords internal
#'
#' @rdname emr_describe_step
emr_describe_step <- function(ClusterId, StepId) {
  op <- new_operation(
    name = "DescribeStep",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_step_input(ClusterId = ClusterId, StepId = StepId)
  output <- .emr$describe_step_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_step <- emr_describe_step

#' Returns details for the specified Amazon EMR Studio including ID, Name,
#' VPC, Studio access URL, and so on
#'
#' @description
#' Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.
#'
#' See [https://paws-r.github.io/docs/emr/describe_studio.html](https://paws-r.github.io/docs/emr/describe_studio.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The Amazon EMR Studio ID.
#'
#' @keywords internal
#'
#' @rdname emr_describe_studio
emr_describe_studio <- function(StudioId) {
  op <- new_operation(
    name = "DescribeStudio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$describe_studio_input(StudioId = StudioId)
  output <- .emr$describe_studio_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$describe_studio <- emr_describe_studio

#' Returns the auto-termination policy for an Amazon EMR cluster
#'
#' @description
#' Returns the auto-termination policy for an Amazon EMR cluster.
#'
#' See [https://paws-r.github.io/docs/emr/get_auto_termination_policy.html](https://paws-r.github.io/docs/emr/get_auto_termination_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the Amazon EMR cluster for which the
#' auto-termination policy will be fetched.
#'
#' @keywords internal
#'
#' @rdname emr_get_auto_termination_policy
emr_get_auto_termination_policy <- function(ClusterId) {
  op <- new_operation(
    name = "GetAutoTerminationPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_auto_termination_policy_input(ClusterId = ClusterId)
  output <- .emr$get_auto_termination_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_auto_termination_policy <- emr_get_auto_termination_policy

#' Returns the Amazon EMR block public access configuration for your Amazon
#' Web Services account in the current Region
#'
#' @description
#' Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/) in the *Amazon EMR Management Guide*.
#'
#' See [https://paws-r.github.io/docs/emr/get_block_public_access_configuration.html](https://paws-r.github.io/docs/emr/get_block_public_access_configuration.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname emr_get_block_public_access_configuration
emr_get_block_public_access_configuration <- function() {
  op <- new_operation(
    name = "GetBlockPublicAccessConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_block_public_access_configuration_input()
  output <- .emr$get_block_public_access_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_block_public_access_configuration <- emr_get_block_public_access_configuration

#' Fetches the attached managed scaling policy for an Amazon EMR cluster
#'
#' @description
#' Fetches the attached managed scaling policy for an Amazon EMR cluster.
#'
#' See [https://paws-r.github.io/docs/emr/get_managed_scaling_policy.html](https://paws-r.github.io/docs/emr/get_managed_scaling_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the cluster for which the managed scaling policy
#' will be fetched.
#'
#' @keywords internal
#'
#' @rdname emr_get_managed_scaling_policy
emr_get_managed_scaling_policy <- function(ClusterId) {
  op <- new_operation(
    name = "GetManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_managed_scaling_policy_input(ClusterId = ClusterId)
  output <- .emr$get_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_managed_scaling_policy <- emr_get_managed_scaling_policy

#' Fetches mapping details for the specified Amazon EMR Studio and identity
#' (user or group)
#'
#' @description
#' Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).
#'
#' See [https://paws-r.github.io/docs/emr/get_studio_session_mapping.html](https://paws-r.github.io/docs/emr/get_studio_session_mapping.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio.
#' @param IdentityId The globally unique identifier (GUID) of the user or group. For more
#' information, see
#' [UserId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
#' and
#' [GroupId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityName The name of the user or group to fetch. For more information, see
#' [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
#' and
#' [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityType &#91;required&#93; Specifies whether the identity to fetch is a user or a group.
#'
#' @keywords internal
#'
#' @rdname emr_get_studio_session_mapping
emr_get_studio_session_mapping <- function(StudioId, IdentityId = NULL, IdentityName = NULL, IdentityType) {
  op <- new_operation(
    name = "GetStudioSessionMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$get_studio_session_mapping_input(StudioId = StudioId, IdentityId = IdentityId, IdentityName = IdentityName, IdentityType = IdentityType)
  output <- .emr$get_studio_session_mapping_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$get_studio_session_mapping <- emr_get_studio_session_mapping

#' Provides information about the bootstrap actions associated with a
#' cluster
#'
#' @description
#' Provides information about the bootstrap actions associated with a cluster.
#'
#' See [https://paws-r.github.io/docs/emr/list_bootstrap_actions.html](https://paws-r.github.io/docs/emr/list_bootstrap_actions.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The cluster identifier for the bootstrap actions to list.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_bootstrap_actions
emr_list_bootstrap_actions <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListBootstrapActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_bootstrap_actions_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_bootstrap_actions_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_bootstrap_actions <- emr_list_bootstrap_actions

#' Provides the status of all clusters visible to this Amazon Web Services
#' account
#'
#' @description
#' Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.
#'
#' See [https://paws-r.github.io/docs/emr/list_clusters.html](https://paws-r.github.io/docs/emr/list_clusters.html) for full documentation.
#'
#' @param CreatedAfter The creation date and time beginning value filter for listing clusters.
#' @param CreatedBefore The creation date and time end value filter for listing clusters.
#' @param ClusterStates The cluster state filters to apply when listing clusters. Clusters that
#' change state while this action runs may be not be returned as expected
#' in the list of clusters.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_clusters
emr_list_clusters <- function(CreatedAfter = NULL, CreatedBefore = NULL, ClusterStates = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_clusters_input(CreatedAfter = CreatedAfter, CreatedBefore = CreatedBefore, ClusterStates = ClusterStates, Marker = Marker)
  output <- .emr$list_clusters_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_clusters <- emr_list_clusters

#' Lists all available details about the instance fleets in a cluster
#'
#' @description
#' Lists all available details about the instance fleets in a cluster.
#'
#' See [https://paws-r.github.io/docs/emr/list_instance_fleets.html](https://paws-r.github.io/docs/emr/list_instance_fleets.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_instance_fleets
emr_list_instance_fleets <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListInstanceFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instance_fleets_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_instance_fleets_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instance_fleets <- emr_list_instance_fleets

#' Provides all available details about the instance groups in a cluster
#'
#' @description
#' Provides all available details about the instance groups in a cluster.
#'
#' See [https://paws-r.github.io/docs/emr/list_instance_groups.html](https://paws-r.github.io/docs/emr/list_instance_groups.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the instance groups.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_instance_groups
emr_list_instance_groups <- function(ClusterId, Marker = NULL) {
  op <- new_operation(
    name = "ListInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instance_groups_input(ClusterId = ClusterId, Marker = Marker)
  output <- .emr$list_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instance_groups <- emr_list_instance_groups

#' Provides information for all active EC2 instances and EC2 instances
#' terminated in the last 30 days, up to a maximum of 2,000
#'
#' @description
#' Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
#'
#' See [https://paws-r.github.io/docs/emr/list_instances.html](https://paws-r.github.io/docs/emr/list_instances.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the instances.
#' @param InstanceGroupId The identifier of the instance group for which to list the instances.
#' @param InstanceGroupTypes The type of instance group for which to list the instances.
#' @param InstanceFleetId The unique identifier of the instance fleet.
#' @param InstanceFleetType The node type of the instance fleet. For example MASTER, CORE, or TASK.
#' @param InstanceStates A list of instance states that will filter the instances returned with
#' this request.
#' @param Marker The pagination token that indicates the next set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_instances
emr_list_instances <- function(ClusterId, InstanceGroupId = NULL, InstanceGroupTypes = NULL, InstanceFleetId = NULL, InstanceFleetType = NULL, InstanceStates = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_instances_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId, InstanceGroupTypes = InstanceGroupTypes, InstanceFleetId = InstanceFleetId, InstanceFleetType = InstanceFleetType, InstanceStates = InstanceStates, Marker = Marker)
  output <- .emr$list_instances_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_instances <- emr_list_instances

#' Provides summaries of all notebook executions
#'
#' @description
#' Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple `ListNotebookExecution` calls.
#'
#' See [https://paws-r.github.io/docs/emr/list_notebook_executions.html](https://paws-r.github.io/docs/emr/list_notebook_executions.html) for full documentation.
#'
#' @param EditorId The unique ID of the editor associated with the notebook execution.
#' @param Status The status filter for listing notebook executions.
#' 
#' -   `START_PENDING` indicates that the cluster has received the
#'     execution request but execution has not begun.
#' 
#' -   `STARTING` indicates that the execution is starting on the cluster.
#' 
#' -   `RUNNING` indicates that the execution is being processed by the
#'     cluster.
#' 
#' -   `FINISHING` indicates that execution processing is in the final
#'     stages.
#' 
#' -   `FINISHED` indicates that the execution has completed without error.
#' 
#' -   `FAILING` indicates that the execution is failing and will not
#'     finish successfully.
#' 
#' -   `FAILED` indicates that the execution failed.
#' 
#' -   `STOP_PENDING` indicates that the cluster has received a
#'     [`stop_notebook_execution`][emr_stop_notebook_execution] request and
#'     the stop is pending.
#' 
#' -   `STOPPING` indicates that the cluster is in the process of stopping
#'     the execution as a result of a
#'     [`stop_notebook_execution`][emr_stop_notebook_execution] request.
#' 
#' -   `STOPPED` indicates that the execution stopped because of a
#'     [`stop_notebook_execution`][emr_stop_notebook_execution] request.
#' @param From The beginning of time range filter for listing notebook executions. The
#' default is the timestamp of 30 days ago.
#' @param To The end of time range filter for listing notebook executions. The
#' default is the current timestamp.
#' @param Marker The pagination token, returned by a previous
#' [`list_notebook_executions`][emr_list_notebook_executions] call, that
#' indicates the start of the list for this
#' [`list_notebook_executions`][emr_list_notebook_executions] call.
#'
#' @keywords internal
#'
#' @rdname emr_list_notebook_executions
emr_list_notebook_executions <- function(EditorId = NULL, Status = NULL, From = NULL, To = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListNotebookExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_notebook_executions_input(EditorId = EditorId, Status = Status, From = From, To = To, Marker = Marker)
  output <- .emr$list_notebook_executions_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_notebook_executions <- emr_list_notebook_executions

#' Retrieves release labels of EMR services in the region where the API is
#' called
#'
#' @description
#' Retrieves release labels of EMR services in the region where the API is called.
#'
#' See [https://paws-r.github.io/docs/emr/list_release_labels.html](https://paws-r.github.io/docs/emr/list_release_labels.html) for full documentation.
#'
#' @param Filters Filters the results of the request. `Prefix` specifies the prefix of
#' release labels to return. `Application` specifies the application
#' (with/without version) of release labels to return.
#' @param NextToken Specifies the next page of results. If `NextToken` is not specified,
#' which is usually the case for the first request of ListReleaseLabels,
#' the first page of results are determined by other filtering parameters
#' or by the latest version. The
#' [`list_release_labels`][emr_list_release_labels] request fails if the
#' identity (Amazon Web Services account ID) and all filtering parameters
#' are different from the original request, or if the `NextToken` is
#' expired or tampered with.
#' @param MaxResults Defines the maximum number of release labels to return in a single
#' response. The default is `100`.
#'
#' @keywords internal
#'
#' @rdname emr_list_release_labels
emr_list_release_labels <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListReleaseLabels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_release_labels_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .emr$list_release_labels_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_release_labels <- emr_list_release_labels

#' Lists all the security configurations visible to this account, providing
#' their creation dates and times, and their names
#'
#' @description
#' Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.
#'
#' See [https://paws-r.github.io/docs/emr/list_security_configurations.html](https://paws-r.github.io/docs/emr/list_security_configurations.html) for full documentation.
#'
#' @param Marker The pagination token that indicates the set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_security_configurations
emr_list_security_configurations <- function(Marker = NULL) {
  op <- new_operation(
    name = "ListSecurityConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_security_configurations_input(Marker = Marker)
  output <- .emr$list_security_configurations_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_security_configurations <- emr_list_security_configurations

#' Provides a list of steps for the cluster in reverse order unless you
#' specify stepIds with the request or filter by StepStates
#'
#' @description
#' Provides a list of steps for the cluster in reverse order unless you specify `stepIds` with the request or filter by `StepStates`. You can specify a maximum of 10 `stepIDs`. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a `Marker`, which is a pagination token that indicates the next set of steps to retrieve.
#'
#' See [https://paws-r.github.io/docs/emr/list_steps.html](https://paws-r.github.io/docs/emr/list_steps.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The identifier of the cluster for which to list the steps.
#' @param StepStates The filter to limit the step list based on certain states.
#' @param StepIds The filter to limit the step list based on the identifier of the steps.
#' You can specify a maximum of ten Step IDs. The character constraint
#' applies to the overall length of the array.
#' @param Marker The maximum number of steps that a single [`list_steps`][emr_list_steps]
#' action returns is 50. To return a longer list of steps, use multiple
#' [`list_steps`][emr_list_steps] actions along with the `Marker`
#' parameter, which is a pagination token that indicates the next set of
#' results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_steps
emr_list_steps <- function(ClusterId, StepStates = NULL, StepIds = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListSteps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_steps_input(ClusterId = ClusterId, StepStates = StepStates, StepIds = StepIds, Marker = Marker)
  output <- .emr$list_steps_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_steps <- emr_list_steps

#' Returns a list of all user or group session mappings for the Amazon EMR
#' Studio specified by StudioId
#'
#' @description
#' Returns a list of all user or group session mappings for the Amazon EMR Studio specified by `StudioId`.
#'
#' See [https://paws-r.github.io/docs/emr/list_studio_session_mappings.html](https://paws-r.github.io/docs/emr/list_studio_session_mappings.html) for full documentation.
#'
#' @param StudioId The ID of the Amazon EMR Studio.
#' @param IdentityType Specifies whether to return session mappings for users or groups. If not
#' specified, the results include session mapping details for both users
#' and groups.
#' @param Marker The pagination token that indicates the set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_studio_session_mappings
emr_list_studio_session_mappings <- function(StudioId = NULL, IdentityType = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListStudioSessionMappings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_studio_session_mappings_input(StudioId = StudioId, IdentityType = IdentityType, Marker = Marker)
  output <- .emr$list_studio_session_mappings_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_studio_session_mappings <- emr_list_studio_session_mappings

#' Returns a list of all Amazon EMR Studios associated with the Amazon Web
#' Services account
#'
#' @description
#' Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.
#'
#' See [https://paws-r.github.io/docs/emr/list_studios.html](https://paws-r.github.io/docs/emr/list_studios.html) for full documentation.
#'
#' @param Marker The pagination token that indicates the set of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname emr_list_studios
emr_list_studios <- function(Marker = NULL) {
  op <- new_operation(
    name = "ListStudios",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$list_studios_input(Marker = Marker)
  output <- .emr$list_studios_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$list_studios <- emr_list_studios

#' Modifies the number of steps that can be executed concurrently for the
#' cluster specified using ClusterID
#'
#' @description
#' Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.
#'
#' See [https://paws-r.github.io/docs/emr/modify_cluster.html](https://paws-r.github.io/docs/emr/modify_cluster.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param StepConcurrencyLevel The number of steps that can be executed concurrently. You can specify a
#' minimum of 1 step and a maximum of 256 steps. We recommend that you do
#' not change this parameter while steps are running or the
#' `ActionOnFailure` setting may not behave as expected. For more
#' information see Step$ActionOnFailure.
#'
#' @keywords internal
#'
#' @rdname emr_modify_cluster
emr_modify_cluster <- function(ClusterId, StepConcurrencyLevel = NULL) {
  op <- new_operation(
    name = "ModifyCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_cluster_input(ClusterId = ClusterId, StepConcurrencyLevel = StepConcurrencyLevel)
  output <- .emr$modify_cluster_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_cluster <- emr_modify_cluster

#' Modifies the target On-Demand and target Spot capacities for the
#' instance fleet with the specified InstanceFleetID within the cluster
#' specified using ClusterID
#'
#' @description
#' Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.
#'
#' See [https://paws-r.github.io/docs/emr/modify_instance_fleet.html](https://paws-r.github.io/docs/emr/modify_instance_fleet.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; The unique identifier of the cluster.
#' @param InstanceFleet &#91;required&#93; The configuration parameters of the instance fleet.
#'
#' @keywords internal
#'
#' @rdname emr_modify_instance_fleet
emr_modify_instance_fleet <- function(ClusterId, InstanceFleet) {
  op <- new_operation(
    name = "ModifyInstanceFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_instance_fleet_input(ClusterId = ClusterId, InstanceFleet = InstanceFleet)
  output <- .emr$modify_instance_fleet_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_instance_fleet <- emr_modify_instance_fleet

#' ModifyInstanceGroups modifies the number of nodes and configuration
#' settings of an instance group
#'
#' @description
#' ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.
#'
#' See [https://paws-r.github.io/docs/emr/modify_instance_groups.html](https://paws-r.github.io/docs/emr/modify_instance_groups.html) for full documentation.
#'
#' @param ClusterId The ID of the cluster to which the instance group belongs.
#' @param InstanceGroups Instance groups to change.
#'
#' @keywords internal
#'
#' @rdname emr_modify_instance_groups
emr_modify_instance_groups <- function(ClusterId = NULL, InstanceGroups = NULL) {
  op <- new_operation(
    name = "ModifyInstanceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$modify_instance_groups_input(ClusterId = ClusterId, InstanceGroups = InstanceGroups)
  output <- .emr$modify_instance_groups_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$modify_instance_groups <- emr_modify_instance_groups

#' Creates or updates an automatic scaling policy for a core instance group
#' or task instance group in an Amazon EMR cluster
#'
#' @description
#' Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.
#'
#' See [https://paws-r.github.io/docs/emr/put_auto_scaling_policy.html](https://paws-r.github.io/docs/emr/put_auto_scaling_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of a cluster. The instance group to which the automatic
#' scaling policy is applied is within this cluster.
#' @param InstanceGroupId &#91;required&#93; Specifies the ID of the instance group to which the automatic scaling
#' policy is applied.
#' @param AutoScalingPolicy &#91;required&#93; Specifies the definition of the automatic scaling policy.
#'
#' @keywords internal
#'
#' @rdname emr_put_auto_scaling_policy
emr_put_auto_scaling_policy <- function(ClusterId, InstanceGroupId, AutoScalingPolicy) {
  op <- new_operation(
    name = "PutAutoScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_auto_scaling_policy_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId, AutoScalingPolicy = AutoScalingPolicy)
  output <- .emr$put_auto_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_auto_scaling_policy <- emr_put_auto_scaling_policy

#' Auto-termination is supported in Amazon EMR versions 5
#'
#' @description
#' Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see [Using an auto-termination policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html).
#'
#' See [https://paws-r.github.io/docs/emr/put_auto_termination_policy.html](https://paws-r.github.io/docs/emr/put_auto_termination_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the Amazon EMR cluster to which the auto-termination
#' policy will be attached.
#' @param AutoTerminationPolicy Specifies the auto-termination policy to attach to the cluster.
#'
#' @keywords internal
#'
#' @rdname emr_put_auto_termination_policy
emr_put_auto_termination_policy <- function(ClusterId, AutoTerminationPolicy = NULL) {
  op <- new_operation(
    name = "PutAutoTerminationPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_auto_termination_policy_input(ClusterId = ClusterId, AutoTerminationPolicy = AutoTerminationPolicy)
  output <- .emr$put_auto_termination_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_auto_termination_policy <- emr_put_auto_termination_policy

#' Creates or updates an Amazon EMR block public access configuration for
#' your Amazon Web Services account in the current Region
#'
#' @description
#' Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see [Configure Block Public Access for Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/) in the *Amazon EMR Management Guide*.
#'
#' See [https://paws-r.github.io/docs/emr/put_block_public_access_configuration.html](https://paws-r.github.io/docs/emr/put_block_public_access_configuration.html) for full documentation.
#'
#' @param BlockPublicAccessConfiguration &#91;required&#93; A configuration for Amazon EMR block public access. The configuration
#' applies to all clusters created in your account for the current Region.
#' The configuration specifies whether block public access is enabled. If
#' block public access is enabled, security groups associated with the
#' cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or
#' ::/0 on a port, unless the port is specified as an exception using
#' `PermittedPublicSecurityGroupRuleRanges` in the
#' `BlockPublicAccessConfiguration`. By default, Port 22 (SSH) is an
#' exception, and public access is allowed on this port. You can change
#' this by updating `BlockPublicSecurityGroupRules` to remove the
#' exception.
#' 
#' For accounts that created clusters in a Region before November 25, 2019,
#' block public access is disabled by default in that Region. To use this
#' feature, you must manually enable and configure it. For accounts that
#' did not create an EMR cluster in a Region before this date, block public
#' access is enabled by default in that Region.
#'
#' @keywords internal
#'
#' @rdname emr_put_block_public_access_configuration
emr_put_block_public_access_configuration <- function(BlockPublicAccessConfiguration) {
  op <- new_operation(
    name = "PutBlockPublicAccessConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_block_public_access_configuration_input(BlockPublicAccessConfiguration = BlockPublicAccessConfiguration)
  output <- .emr$put_block_public_access_configuration_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_block_public_access_configuration <- emr_put_block_public_access_configuration

#' Creates or updates a managed scaling policy for an Amazon EMR cluster
#'
#' @description
#' Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration.
#'
#' See [https://paws-r.github.io/docs/emr/put_managed_scaling_policy.html](https://paws-r.github.io/docs/emr/put_managed_scaling_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of an EMR cluster where the managed scaling policy is
#' attached.
#' @param ManagedScalingPolicy &#91;required&#93; Specifies the constraints for the managed scaling policy.
#'
#' @keywords internal
#'
#' @rdname emr_put_managed_scaling_policy
emr_put_managed_scaling_policy <- function(ClusterId, ManagedScalingPolicy) {
  op <- new_operation(
    name = "PutManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$put_managed_scaling_policy_input(ClusterId = ClusterId, ManagedScalingPolicy = ManagedScalingPolicy)
  output <- .emr$put_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$put_managed_scaling_policy <- emr_put_managed_scaling_policy

#' Removes an automatic scaling policy from a specified instance group
#' within an EMR cluster
#'
#' @description
#' Removes an automatic scaling policy from a specified instance group within an EMR cluster.
#'
#' See [https://paws-r.github.io/docs/emr/remove_auto_scaling_policy.html](https://paws-r.github.io/docs/emr/remove_auto_scaling_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of a cluster. The instance group to which the automatic
#' scaling policy is applied is within this cluster.
#' @param InstanceGroupId &#91;required&#93; Specifies the ID of the instance group to which the scaling policy is
#' applied.
#'
#' @keywords internal
#'
#' @rdname emr_remove_auto_scaling_policy
emr_remove_auto_scaling_policy <- function(ClusterId, InstanceGroupId) {
  op <- new_operation(
    name = "RemoveAutoScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_auto_scaling_policy_input(ClusterId = ClusterId, InstanceGroupId = InstanceGroupId)
  output <- .emr$remove_auto_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_auto_scaling_policy <- emr_remove_auto_scaling_policy

#' Removes an auto-termination policy from an Amazon EMR cluster
#'
#' @description
#' Removes an auto-termination policy from an Amazon EMR cluster.
#'
#' See [https://paws-r.github.io/docs/emr/remove_auto_termination_policy.html](https://paws-r.github.io/docs/emr/remove_auto_termination_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the Amazon EMR cluster from which the
#' auto-termination policy will be removed.
#'
#' @keywords internal
#'
#' @rdname emr_remove_auto_termination_policy
emr_remove_auto_termination_policy <- function(ClusterId) {
  op <- new_operation(
    name = "RemoveAutoTerminationPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_auto_termination_policy_input(ClusterId = ClusterId)
  output <- .emr$remove_auto_termination_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_auto_termination_policy <- emr_remove_auto_termination_policy

#' Removes a managed scaling policy from a specified EMR cluster
#'
#' @description
#' Removes a managed scaling policy from a specified EMR cluster.
#'
#' See [https://paws-r.github.io/docs/emr/remove_managed_scaling_policy.html](https://paws-r.github.io/docs/emr/remove_managed_scaling_policy.html) for full documentation.
#'
#' @param ClusterId &#91;required&#93; Specifies the ID of the cluster from which the managed scaling policy
#' will be removed.
#'
#' @keywords internal
#'
#' @rdname emr_remove_managed_scaling_policy
emr_remove_managed_scaling_policy <- function(ClusterId) {
  op <- new_operation(
    name = "RemoveManagedScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_managed_scaling_policy_input(ClusterId = ClusterId)
  output <- .emr$remove_managed_scaling_policy_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_managed_scaling_policy <- emr_remove_managed_scaling_policy

#' Removes tags from an Amazon EMR resource, such as a cluster or Amazon
#' EMR Studio
#'
#' @description
#' Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see [Tag Clusters](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html).
#'
#' See [https://paws-r.github.io/docs/emr/remove_tags.html](https://paws-r.github.io/docs/emr/remove_tags.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The Amazon EMR resource identifier from which tags will be removed. For
#' example, a cluster identifier or an Amazon EMR Studio ID.
#' @param TagKeys &#91;required&#93; A list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname emr_remove_tags
emr_remove_tags <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$remove_tags_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .emr$remove_tags_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$remove_tags <- emr_remove_tags

#' RunJobFlow creates and starts running a new cluster (job flow)
#'
#' @description
#' RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig `KeepJobFlowAliveWhenNoSteps` parameter is set to `TRUE`, the cluster transitions to the WAITING state rather than shutting down after the steps have completed.
#'
#' See [https://paws-r.github.io/docs/emr/run_job_flow.html](https://paws-r.github.io/docs/emr/run_job_flow.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job flow.
#' @param LogUri The location in Amazon S3 to write the log files of the job flow. If a
#' value is not provided, logs are not created.
#' @param LogEncryptionKmsKeyId The KMS key used for encrypting log files. If a value is not provided,
#' the logs remain encrypted by AES-256. This attribute is only available
#' with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.
#' @param AdditionalInfo A JSON string for selecting additional features.
#' @param AmiVersion Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR
#' releases 4.0 and later, `ReleaseLabel` is used. To specify a custom AMI,
#' use `CustomAmiID`.
#' @param ReleaseLabel The Amazon EMR release label, which determines the version of
#' open-source application packages installed on the cluster. Release
#' labels are in the form `emr-x.x.x`, where x.x.x is an Amazon EMR release
#' version such as `emr-5.14.0`. For more information about Amazon EMR
#' release versions and included application versions and features, see
#' <https://docs.aws.amazon.com/emr/latest/ReleaseGuide/>. The release
#' label applies only to Amazon EMR releases version 4.0 and later. Earlier
#' versions use `AmiVersion`.
#' @param Instances &#91;required&#93; A specification of the number and type of Amazon EC2 instances.
#' @param Steps A list of steps to run.
#' @param BootstrapActions A list of bootstrap actions to run before Hadoop starts on the cluster
#' nodes.
#' @param SupportedProducts For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
#' later, use Applications.
#' 
#' A list of strings that indicates third-party software to use. For more
#' information, see the [Amazon EMR Developer
#' Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-3x.html).
#' Currently supported values are:
#' 
#' -   "mapr-m3" - launch the job flow using MapR M3 Edition.
#' 
#' -   "mapr-m5" - launch the job flow using MapR M5 Edition.
#' @param NewSupportedProducts For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and
#' later, use Applications.
#' 
#' A list of strings that indicates third-party software to use with the
#' job flow that accepts a user argument list. EMR accepts and forwards the
#' argument list to the corresponding installation script as bootstrap
#' action arguments. For more information, see "Launch a Job Flow on the
#' MapR Distribution for Hadoop" in the [Amazon EMR Developer
#' Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-3x.html).
#' Supported values are:
#' 
#' -   "mapr-m3" - launch the cluster using MapR M3 Edition.
#' 
#' -   "mapr-m5" - launch the cluster using MapR M5 Edition.
#' 
#' -   "mapr" with the user arguments specifying "--edition,m3" or
#'     "--edition,m5" - launch the job flow using MapR M3 or M5 Edition
#'     respectively.
#' 
#' -   "mapr-m7" - launch the cluster using MapR M7 Edition.
#' 
#' -   "hunk" - launch the cluster with the Hunk Big Data Analytics
#'     Platform.
#' 
#' -   "hue"- launch the cluster with Hue installed.
#' 
#' -   "spark" - launch the cluster with Apache Spark installed.
#' 
#' -   "ganglia" - launch the cluster with the Ganglia Monitoring System
#'     installed.
#' @param Applications Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of
#' applications for Amazon EMR to install and configure when launching the
#' cluster. For a list of applications available for each Amazon EMR
#' release version, see the [Amazon EMRRelease
#' Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/).
#' @param Configurations For Amazon EMR releases 4.0 and later. The list of configurations
#' supplied for the EMR cluster you are creating.
#' @param VisibleToAllUsers The VisibleToAllUsers parameter is no longer supported. By default, the
#' value is set to `true`. Setting it to `false` now has no effect.
#' 
#' Set this value to `true` so that IAM principals in the Amazon Web
#' Services account associated with the cluster can perform EMR actions on
#' the cluster that their IAM policies allow. This value defaults to `true`
#' for clusters created using the EMR API or the CLI
#' [create-cluster](https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html)
#' command.
#' 
#' When set to `false`, only the IAM principal that created the cluster and
#' the Amazon Web Services account root user can perform EMR actions for
#' the cluster, regardless of the IAM permissions policies attached to
#' other IAM principals. For more information, see [Understanding the EMR
#' Cluster VisibleToAllUsers
#' Setting](https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users)
#' in the *Amazon EMRManagement Guide*.
#' @param JobFlowRole Also called instance profile and EC2 role. An IAM role for an EMR
#' cluster. The EC2 instances of the cluster assume this role. The default
#' role is `EMR_EC2_DefaultRole`. In order to use the default role, you
#' must have already created it using the CLI or console.
#' @param ServiceRole The IAM role that Amazon EMR assumes in order to access Amazon Web
#' Services resources on your behalf.
#' @param Tags A list of tags to associate with a cluster and propagate to Amazon EC2
#' instances.
#' @param SecurityConfiguration The name of a security configuration to apply to the cluster.
#' @param AutoScalingRole An IAM role for automatic scaling policies. The default role is
#' `EMR_AutoScaling_DefaultRole`. The IAM role provides permissions that
#' the automatic scaling feature requires to launch and terminate EC2
#' instances in an instance group.
#' @param ScaleDownBehavior Specifies the way that individual Amazon EC2 instances terminate when an
#' automatic scale-in activity occurs or an instance group is resized.
#' `TERMINATE_AT_INSTANCE_HOUR` indicates that Amazon EMR terminates nodes
#' at the instance-hour boundary, regardless of when the request to
#' terminate the instance was submitted. This option is only available with
#' Amazon EMR 5.1.0 and later and is the default for clusters created using
#' that version. `TERMINATE_AT_TASK_COMPLETION` indicates that Amazon EMR
#' adds nodes to a deny list and drains tasks from nodes before terminating
#' the Amazon EC2 instances, regardless of the instance-hour boundary. With
#' either behavior, Amazon EMR removes the least active nodes first and
#' blocks instance termination if it could lead to HDFS corruption.
#' `TERMINATE_AT_TASK_COMPLETION` available only in Amazon EMR version
#' 4.1.0 and later, and is the default for versions of Amazon EMR earlier
#' than 5.1.0.
#' @param CustomAmiId Available only in Amazon EMR version 5.7.0 and later. The ID of a custom
#' Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when
#' it launches cluster EC2 instances. For more information about custom
#' AMIs in Amazon EMR, see [Using a Custom
#' AMI](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html)
#' in the *Amazon EMR Management Guide*. If omitted, the cluster uses the
#' base Linux AMI for the `ReleaseLabel` specified. For Amazon EMR versions
#' 2.x and 3.x, use `AmiVersion` instead.
#' 
#' For information about creating a custom AMI, see [Creating an Amazon
#' EBS-Backed Linux
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
#' in the *Amazon Elastic Compute Cloud User Guide for Linux Instances*.
#' For information about finding an AMI ID, see [Finding a Linux
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html).
#' @param EbsRootVolumeSize The size, in GiB, of the Amazon EBS root device volume of the Linux AMI
#' that is used for each EC2 instance. Available in Amazon EMR version 4.x
#' and later.
#' @param RepoUpgradeOnBoot Applies only when `CustomAmiID` is used. Specifies which updates from
#' the Amazon Linux AMI package repositories to apply automatically when
#' the instance boots using the AMI. If omitted, the default is `SECURITY`,
#' which indicates that only security updates are applied. If `NONE` is
#' specified, no updates are applied, and all updates must be applied
#' manually.
#' @param KerberosAttributes Attributes for Kerberos configuration when Kerberos authentication is
#' enabled using a security configuration. For more information see [Use
#' Kerberos
#' Authentication](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html)
#' in the *Amazon EMR Management Guide*.
#' @param StepConcurrencyLevel Specifies the number of steps that can be executed concurrently. The
#' default value is `1`. The maximum value is `256`.
#' @param ManagedScalingPolicy The specified managed scaling policy for an Amazon EMR cluster.
#' @param PlacementGroupConfigs The specified placement group configuration for an Amazon EMR cluster.
#' @param AutoTerminationPolicy 
#' @param OSReleaseLabel Specifies a particular Amazon Linux release for all nodes in a cluster
#' launch RunJobFlow request. If a release is not specified, Amazon EMR
#' uses the latest validated Amazon Linux release for cluster launch.
#'
#' @keywords internal
#'
#' @rdname emr_run_job_flow
emr_run_job_flow <- function(Name, LogUri = NULL, LogEncryptionKmsKeyId = NULL, AdditionalInfo = NULL, AmiVersion = NULL, ReleaseLabel = NULL, Instances, Steps = NULL, BootstrapActions = NULL, SupportedProducts = NULL, NewSupportedProducts = NULL, Applications = NULL, Configurations = NULL, VisibleToAllUsers = NULL, JobFlowRole = NULL, ServiceRole = NULL, Tags = NULL, SecurityConfiguration = NULL, AutoScalingRole = NULL, ScaleDownBehavior = NULL, CustomAmiId = NULL, EbsRootVolumeSize = NULL, RepoUpgradeOnBoot = NULL, KerberosAttributes = NULL, StepConcurrencyLevel = NULL, ManagedScalingPolicy = NULL, PlacementGroupConfigs = NULL, AutoTerminationPolicy = NULL, OSReleaseLabel = NULL) {
  op <- new_operation(
    name = "RunJobFlow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$run_job_flow_input(Name = Name, LogUri = LogUri, LogEncryptionKmsKeyId = LogEncryptionKmsKeyId, AdditionalInfo = AdditionalInfo, AmiVersion = AmiVersion, ReleaseLabel = ReleaseLabel, Instances = Instances, Steps = Steps, BootstrapActions = BootstrapActions, SupportedProducts = SupportedProducts, NewSupportedProducts = NewSupportedProducts, Applications = Applications, Configurations = Configurations, VisibleToAllUsers = VisibleToAllUsers, JobFlowRole = JobFlowRole, ServiceRole = ServiceRole, Tags = Tags, SecurityConfiguration = SecurityConfiguration, AutoScalingRole = AutoScalingRole, ScaleDownBehavior = ScaleDownBehavior, CustomAmiId = CustomAmiId, EbsRootVolumeSize = EbsRootVolumeSize, RepoUpgradeOnBoot = RepoUpgradeOnBoot, KerberosAttributes = KerberosAttributes, StepConcurrencyLevel = StepConcurrencyLevel, ManagedScalingPolicy = ManagedScalingPolicy, PlacementGroupConfigs = PlacementGroupConfigs, AutoTerminationPolicy = AutoTerminationPolicy, OSReleaseLabel = OSReleaseLabel)
  output <- .emr$run_job_flow_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$run_job_flow <- emr_run_job_flow

#' SetTerminationProtection locks a cluster (job flow) so the EC2 instances
#' in the cluster cannot be terminated by user intervention, an API call,
#' or in the event of a job-flow error
#'
#' @description
#' SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling [`set_termination_protection`][emr_set_termination_protection] on a cluster is similar to calling the Amazon EC2 `DisableAPITermination` API on all EC2 instances in a cluster.
#'
#' See [https://paws-r.github.io/docs/emr/set_termination_protection.html](https://paws-r.github.io/docs/emr/set_termination_protection.html) for full documentation.
#'
#' @param JobFlowIds &#91;required&#93; A list of strings that uniquely identify the clusters to protect. This
#' identifier is returned by [`run_job_flow`][emr_run_job_flow] and can
#' also be obtained from [`describe_job_flows`][emr_describe_job_flows] .
#' @param TerminationProtected &#91;required&#93; A Boolean that indicates whether to protect the cluster and prevent the
#' Amazon EC2 instances in the cluster from shutting down due to API calls,
#' user intervention, or job-flow error.
#'
#' @keywords internal
#'
#' @rdname emr_set_termination_protection
emr_set_termination_protection <- function(JobFlowIds, TerminationProtected) {
  op <- new_operation(
    name = "SetTerminationProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$set_termination_protection_input(JobFlowIds = JobFlowIds, TerminationProtected = TerminationProtected)
  output <- .emr$set_termination_protection_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$set_termination_protection <- emr_set_termination_protection

#' The SetVisibleToAllUsers parameter is no longer supported
#'
#' @description
#' The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see [Identity and Access Management for EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html).
#'
#' See [https://paws-r.github.io/docs/emr/set_visible_to_all_users.html](https://paws-r.github.io/docs/emr/set_visible_to_all_users.html) for full documentation.
#'
#' @param JobFlowIds &#91;required&#93; The unique identifier of the job flow (cluster).
#' @param VisibleToAllUsers &#91;required&#93; A value of `true` indicates that an IAM principal in the Amazon Web
#' Services account can perform EMR actions on the cluster that the IAM
#' policies attached to the principal allow. A value of `false` indicates
#' that only the IAM principal that created the cluster and the Amazon Web
#' Services root user can perform EMR actions on the cluster.
#'
#' @keywords internal
#'
#' @rdname emr_set_visible_to_all_users
emr_set_visible_to_all_users <- function(JobFlowIds, VisibleToAllUsers) {
  op <- new_operation(
    name = "SetVisibleToAllUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$set_visible_to_all_users_input(JobFlowIds = JobFlowIds, VisibleToAllUsers = VisibleToAllUsers)
  output <- .emr$set_visible_to_all_users_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$set_visible_to_all_users <- emr_set_visible_to_all_users

#' Starts a notebook execution
#'
#' @description
#' Starts a notebook execution.
#'
#' See [https://paws-r.github.io/docs/emr/start_notebook_execution.html](https://paws-r.github.io/docs/emr/start_notebook_execution.html) for full documentation.
#'
#' @param EditorId &#91;required&#93; The unique identifier of the EMR Notebook to use for notebook execution.
#' @param RelativePath &#91;required&#93; The path and file name of the notebook file for this execution, relative
#' to the path specified for the EMR Notebook. For example, if you specify
#' a path of `s3://MyBucket/MyNotebooks` when you create an EMR Notebook
#' for a notebook with an ID of `e-ABCDEFGHIJK1234567890ABCD` (the
#' `EditorID` of this request), and you specify a `RelativePath` of
#' `my_notebook_executions/notebook_execution.ipynb`, the location of the
#' file for the notebook execution is
#' `s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb`.
#' @param NotebookExecutionName An optional name for the notebook execution.
#' @param NotebookParams Input parameters in JSON format passed to the EMR Notebook at runtime
#' for execution.
#' @param ExecutionEngine &#91;required&#93; Specifies the execution engine (cluster) that runs the notebook
#' execution.
#' @param ServiceRole &#91;required&#93; The name or ARN of the IAM role that is used as the service role for
#' Amazon EMR (the EMR role) for the notebook execution.
#' @param NotebookInstanceSecurityGroupId The unique identifier of the Amazon EC2 security group to associate with
#' the EMR Notebook for this notebook execution.
#' @param Tags A list of tags associated with a notebook execution. Tags are
#' user-defined key-value pairs that consist of a required key string with
#' a maximum of 128 characters and an optional value string with a maximum
#' of 256 characters.
#'
#' @keywords internal
#'
#' @rdname emr_start_notebook_execution
emr_start_notebook_execution <- function(EditorId, RelativePath, NotebookExecutionName = NULL, NotebookParams = NULL, ExecutionEngine, ServiceRole, NotebookInstanceSecurityGroupId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "StartNotebookExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$start_notebook_execution_input(EditorId = EditorId, RelativePath = RelativePath, NotebookExecutionName = NotebookExecutionName, NotebookParams = NotebookParams, ExecutionEngine = ExecutionEngine, ServiceRole = ServiceRole, NotebookInstanceSecurityGroupId = NotebookInstanceSecurityGroupId, Tags = Tags)
  output <- .emr$start_notebook_execution_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$start_notebook_execution <- emr_start_notebook_execution

#' Stops a notebook execution
#'
#' @description
#' Stops a notebook execution.
#'
#' See [https://paws-r.github.io/docs/emr/stop_notebook_execution.html](https://paws-r.github.io/docs/emr/stop_notebook_execution.html) for full documentation.
#'
#' @param NotebookExecutionId &#91;required&#93; The unique identifier of the notebook execution.
#'
#' @keywords internal
#'
#' @rdname emr_stop_notebook_execution
emr_stop_notebook_execution <- function(NotebookExecutionId) {
  op <- new_operation(
    name = "StopNotebookExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$stop_notebook_execution_input(NotebookExecutionId = NotebookExecutionId)
  output <- .emr$stop_notebook_execution_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$stop_notebook_execution <- emr_stop_notebook_execution

#' TerminateJobFlows shuts a list of clusters (job flows) down
#'
#' @description
#' TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.
#'
#' See [https://paws-r.github.io/docs/emr/terminate_job_flows.html](https://paws-r.github.io/docs/emr/terminate_job_flows.html) for full documentation.
#'
#' @param JobFlowIds &#91;required&#93; A list of job flows to be shut down.
#'
#' @keywords internal
#'
#' @rdname emr_terminate_job_flows
emr_terminate_job_flows <- function(JobFlowIds) {
  op <- new_operation(
    name = "TerminateJobFlows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$terminate_job_flows_input(JobFlowIds = JobFlowIds)
  output <- .emr$terminate_job_flows_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$terminate_job_flows <- emr_terminate_job_flows

#' Updates an Amazon EMR Studio configuration, including attributes such as
#' name, description, and subnets
#'
#' @description
#' Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
#'
#' See [https://paws-r.github.io/docs/emr/update_studio.html](https://paws-r.github.io/docs/emr/update_studio.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio to update.
#' @param Name A descriptive name for the Amazon EMR Studio.
#' @param Description A detailed description to assign to the Amazon EMR Studio.
#' @param SubnetIds A list of subnet IDs to associate with the Amazon EMR Studio. The list
#' can include new subnet IDs, but must also include all of the subnet IDs
#' previously associated with the Studio. The list order does not matter. A
#' Studio can have a maximum of 5 subnets. The subnets must belong to the
#' same VPC as the Studio.
#' @param DefaultS3Location The Amazon S3 location to back up Workspaces and notebook files for the
#' Amazon EMR Studio.
#'
#' @keywords internal
#'
#' @rdname emr_update_studio
emr_update_studio <- function(StudioId, Name = NULL, Description = NULL, SubnetIds = NULL, DefaultS3Location = NULL) {
  op <- new_operation(
    name = "UpdateStudio",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$update_studio_input(StudioId = StudioId, Name = Name, Description = Description, SubnetIds = SubnetIds, DefaultS3Location = DefaultS3Location)
  output <- .emr$update_studio_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$update_studio <- emr_update_studio

#' Updates the session policy attached to the user or group for the
#' specified Amazon EMR Studio
#'
#' @description
#' Updates the session policy attached to the user or group for the specified Amazon EMR Studio.
#'
#' See [https://paws-r.github.io/docs/emr/update_studio_session_mapping.html](https://paws-r.github.io/docs/emr/update_studio_session_mapping.html) for full documentation.
#'
#' @param StudioId &#91;required&#93; The ID of the Amazon EMR Studio.
#' @param IdentityId The globally unique identifier (GUID) of the user or group. For more
#' information, see
#' [UserId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId)
#' and
#' [GroupId](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityName The name of the user or group to update. For more information, see
#' [UserName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName)
#' and
#' [DisplayName](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName)
#' in the *Amazon Web Services SSO Identity Store API Reference*. Either
#' `IdentityName` or `IdentityId` must be specified.
#' @param IdentityType &#91;required&#93; Specifies whether the identity to update is a user or a group.
#' @param SessionPolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the session policy to associate with
#' the specified user or group.
#'
#' @keywords internal
#'
#' @rdname emr_update_studio_session_mapping
emr_update_studio_session_mapping <- function(StudioId, IdentityId = NULL, IdentityName = NULL, IdentityType, SessionPolicyArn) {
  op <- new_operation(
    name = "UpdateStudioSessionMapping",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .emr$update_studio_session_mapping_input(StudioId = StudioId, IdentityId = IdentityId, IdentityName = IdentityName, IdentityType = IdentityType, SessionPolicyArn = SessionPolicyArn)
  output <- .emr$update_studio_session_mapping_output()
  config <- get_config()
  svc <- .emr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emr$operations$update_studio_session_mapping <- emr_update_studio_session_mapping
