# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include athena_service.R
NULL

#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings
#'
#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings. Requires you
#' to have access to the workgroup in which the queries were saved. Use
#' ListNamedQueriesInput to get the list of named query IDs in the
#' specified workgroup. If information could not be retrieved for a
#' submitted query ID, information about the query ID submitted is listed
#' under UnprocessedNamedQueryId. Named queries differ from executed
#' queries. Use BatchGetQueryExecutionInput to get details about each
#' unique query execution, and ListQueryExecutionsInput to get a list of
#' query execution IDs.
#'
#' @usage
#' athena_batch_get_named_query(NamedQueryIds)
#'
#' @param NamedQueryIds &#91;required&#93; An array of query IDs.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_named_query(
#'   NamedQueryIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_named_query
athena_batch_get_named_query <- function(NamedQueryIds) {
  op <- new_operation(
    name = "BatchGetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_named_query_input(NamedQueryIds = NamedQueryIds)
  output <- .athena$batch_get_named_query_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_named_query <- athena_batch_get_named_query

#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings
#'
#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings. Requires you to have access to the workgroup in which the
#' queries ran. To get a list of query execution IDs, use
#' ListQueryExecutionsInput\\$WorkGroup. Query executions differ from named
#' (saved) queries. Use BatchGetNamedQueryInput to get details about named
#' queries.
#'
#' @usage
#' athena_batch_get_query_execution(QueryExecutionIds)
#'
#' @param QueryExecutionIds &#91;required&#93; An array of query execution IDs.
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_query_execution(
#'   QueryExecutionIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_query_execution
athena_batch_get_query_execution <- function(QueryExecutionIds) {
  op <- new_operation(
    name = "BatchGetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_query_execution_input(QueryExecutionIds = QueryExecutionIds)
  output <- .athena$batch_get_query_execution_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_query_execution <- athena_batch_get_query_execution

#' Creates a named query in the specified workgroup
#'
#' Creates a named query in the specified workgroup. Requires that you have
#' access to the workgroup.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_create_named_query(Name, Description, Database, QueryString,
#'   ClientRequestToken, WorkGroup)
#'
#' @param Name &#91;required&#93; The query name.
#' @param Description The query description.
#' @param Database &#91;required&#93; The database to which the query belongs.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another `CreateNamedQuery`
#' request is received, the same response is returned and another query is
#' not created. If a parameter has changed, for example, the `QueryString`,
#' an error is returned.
#' 
#' This token is listed as not required because AWS SDKs (for example the
#' AWS SDK for Java) auto-generate the token for users. If you are not
#' using the AWS SDK or the AWS CLI, you must provide this token or the
#' action will fail.
#' @param WorkGroup The name of the workgroup in which the named query is being created.
#'
#' @section Request syntax:
#' ```
#' svc$create_named_query(
#'   Name = "string",
#'   Description = "string",
#'   Database = "string",
#'   QueryString = "string",
#'   ClientRequestToken = "string",
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_create_named_query
athena_create_named_query <- function(Name, Description = NULL, Database, QueryString, ClientRequestToken = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "CreateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_named_query_input(Name = Name, Description = Description, Database = Database, QueryString = QueryString, ClientRequestToken = ClientRequestToken, WorkGroup = WorkGroup)
  output <- .athena$create_named_query_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_named_query <- athena_create_named_query

#' Creates a workgroup with the specified name
#'
#' Creates a workgroup with the specified name.
#'
#' @usage
#' athena_create_work_group(Name, Configuration, Description, Tags)
#'
#' @param Name &#91;required&#93; The workgroup name.
#' @param Configuration The configuration for the workgroup, which includes the location in
#' Amazon S3 where query results are stored, the encryption configuration,
#' if any, used for encrypting query results, whether the Amazon CloudWatch
#' Metrics are enabled for the workgroup, the limit for the amount of bytes
#' scanned (cutoff) per query, if it is specified, and whether workgroup\'s
#' settings (specified with EnforceWorkGroupConfiguration) in the
#' WorkGroupConfiguration override client-side settings. See
#' WorkGroupConfiguration\\$EnforceWorkGroupConfiguration.
#' @param Description The workgroup description.
#' @param Tags One or more tags, separated by commas, that you want to attach to the
#' workgroup as you create it.
#'
#' @section Request syntax:
#' ```
#' svc$create_work_group(
#'   Name = "string",
#'   Configuration = list(
#'     ResultConfiguration = list(
#'       OutputLocation = "string",
#'       EncryptionConfiguration = list(
#'         EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'         KmsKey = "string"
#'       )
#'     ),
#'     EnforceWorkGroupConfiguration = TRUE|FALSE,
#'     PublishCloudWatchMetricsEnabled = TRUE|FALSE,
#'     BytesScannedCutoffPerQuery = 123
#'   ),
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_create_work_group
athena_create_work_group <- function(Name, Configuration = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_work_group_input(Name = Name, Configuration = Configuration, Description = Description, Tags = Tags)
  output <- .athena$create_work_group_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_work_group <- athena_create_work_group

#' Deletes the named query if you have access to the workgroup in which the
#' query was saved
#'
#' Deletes the named query if you have access to the workgroup in which the
#' query was saved.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_delete_named_query(NamedQueryId)
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_named_query(
#'   NamedQueryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_delete_named_query
athena_delete_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "DeleteNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$delete_named_query_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_named_query <- athena_delete_named_query

#' Deletes the workgroup with the specified name
#'
#' Deletes the workgroup with the specified name. The primary workgroup
#' cannot be deleted.
#'
#' @usage
#' athena_delete_work_group(WorkGroup, RecursiveDeleteOption)
#'
#' @param WorkGroup &#91;required&#93; The unique name of the workgroup to delete.
#' @param RecursiveDeleteOption The option to delete the workgroup and its contents even if the
#' workgroup contains any named queries.
#'
#' @section Request syntax:
#' ```
#' svc$delete_work_group(
#'   WorkGroup = "string",
#'   RecursiveDeleteOption = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_delete_work_group
athena_delete_work_group <- function(WorkGroup, RecursiveDeleteOption = NULL) {
  op <- new_operation(
    name = "DeleteWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_work_group_input(WorkGroup = WorkGroup, RecursiveDeleteOption = RecursiveDeleteOption)
  output <- .athena$delete_work_group_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_work_group <- athena_delete_work_group

#' Returns information about a single query
#'
#' Returns information about a single query. Requires that you have access
#' to the workgroup in which the query was saved.
#'
#' @usage
#' athena_get_named_query(NamedQueryId)
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query. Use ListNamedQueries to get query IDs.
#'
#' @section Request syntax:
#' ```
#' svc$get_named_query(
#'   NamedQueryId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_named_query
athena_get_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "GetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$get_named_query_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_named_query <- athena_get_named_query

#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran
#'
#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran. Each time a query
#' executes, information about the query execution is saved with a unique
#' ID.
#'
#' @usage
#' athena_get_query_execution(QueryExecutionId)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_execution(
#'   QueryExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_query_execution
athena_get_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_execution_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_execution <- athena_get_query_execution

#' Returns the results of a single query execution specified by
#' QueryExecutionId if you have access to the workgroup in which the query
#' ran
#'
#' Returns the results of a single query execution specified by
#' `QueryExecutionId` if you have access to the workgroup in which the
#' query ran. This request does not execute the query but returns results.
#' Use StartQueryExecution to run a query.
#'
#' @usage
#' athena_get_query_results(QueryExecutionId, NextToken, MaxResults)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#' @param NextToken The token that specifies where to start pagination if a previous request
#' was truncated.
#' @param MaxResults The maximum number of results (rows) to return in this request.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_results(
#'   QueryExecutionId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_query_results
athena_get_query_results <- function(QueryExecutionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_results_input(QueryExecutionId = QueryExecutionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$get_query_results_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_results <- athena_get_query_results

#' Returns information about the workgroup with the specified name
#'
#' Returns information about the workgroup with the specified name.
#'
#' @usage
#' athena_get_work_group(WorkGroup)
#'
#' @param WorkGroup &#91;required&#93; The name of the workgroup.
#'
#' @section Request syntax:
#' ```
#' svc$get_work_group(
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_get_work_group
athena_get_work_group <- function(WorkGroup) {
  op <- new_operation(
    name = "GetWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_work_group_input(WorkGroup = WorkGroup)
  output <- .athena$get_work_group_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_work_group <- athena_get_work_group

#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup
#'
#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup. Requires that you have access to the workgroup.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_list_named_queries(NextToken, MaxResults, WorkGroup)
#'
#' @param NextToken The token that specifies where to start pagination if a previous request
#' was truncated.
#' @param MaxResults The maximum number of queries to return in this request.
#' @param WorkGroup The name of the workgroup from which the named queries are being
#' returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_named_queries(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_named_queries
athena_list_named_queries <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListNamedQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_named_queries_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_named_queries_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_named_queries <- athena_list_named_queries

#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup
#'
#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup. Requires you to have access to the workgroup in
#' which the queries ran.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_list_query_executions(NextToken, MaxResults, WorkGroup)
#'
#' @param NextToken The token that specifies where to start pagination if a previous request
#' was truncated.
#' @param MaxResults The maximum number of query executions to return in this request.
#' @param WorkGroup The name of the workgroup from which queries are being returned.
#'
#' @section Request syntax:
#' ```
#' svc$list_query_executions(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_query_executions
athena_list_query_executions <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListQueryExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_query_executions_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_query_executions_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_query_executions <- athena_list_query_executions

#' Lists the tags associated with this workgroup
#'
#' Lists the tags associated with this workgroup.
#'
#' @usage
#' athena_list_tags_for_resource(ResourceARN, NextToken, MaxResults)
#'
#' @param ResourceARN &#91;required&#93; Lists the tags for the workgroup resource with the specified ARN.
#' @param NextToken The token for the next set of results, or null if there are no
#' additional results for this request, where the request lists the tags
#' for the workgroup resource with the specified ARN.
#' @param MaxResults The maximum number of results to be returned per request that lists the
#' tags for the workgroup resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_tags_for_resource
athena_list_tags_for_resource <- function(ResourceARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_tags_for_resource_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_tags_for_resource <- athena_list_tags_for_resource

#' Lists available workgroups for the account
#'
#' Lists available workgroups for the account.
#'
#' @usage
#' athena_list_work_groups(NextToken, MaxResults)
#'
#' @param NextToken A token to be used by the next request if this request is truncated.
#' @param MaxResults The maximum number of workgroups to return in this request.
#'
#' @section Request syntax:
#' ```
#' svc$list_work_groups(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_list_work_groups
athena_list_work_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_work_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_work_groups_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_work_groups <- athena_list_work_groups

#' Runs the SQL query statements contained in the Query
#'
#' Runs the SQL query statements contained in the `Query`. Requires you to
#' have access to the workgroup in which the query ran.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_start_query_execution(QueryString, ClientRequestToken,
#'   QueryExecutionContext, ResultConfiguration, WorkGroup)
#'
#' @param QueryString &#91;required&#93; The SQL query statements to be executed.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' `StartQueryExecution` request is received, the same response is returned
#' and another query is not created. If a parameter has changed, for
#' example, the `QueryString`, an error is returned.
#' 
#' This token is listed as not required because AWS SDKs (for example the
#' AWS SDK for Java) auto-generate the token for users. If you are not
#' using the AWS SDK or the AWS CLI, you must provide this token or the
#' action will fail.
#' @param QueryExecutionContext The database within which the query executes.
#' @param ResultConfiguration Specifies information about where and how to save the results of the
#' query execution. If the query runs in a workgroup, then workgroup\'s
#' settings may override query settings. This affects the query results
#' location. The workgroup settings override is specified in
#' EnforceWorkGroupConfiguration (true/false) in the
#' WorkGroupConfiguration. See
#' WorkGroupConfiguration\\$EnforceWorkGroupConfiguration.
#' @param WorkGroup The name of the workgroup in which the query is being started.
#'
#' @section Request syntax:
#' ```
#' svc$start_query_execution(
#'   QueryString = "string",
#'   ClientRequestToken = "string",
#'   QueryExecutionContext = list(
#'     Database = "string"
#'   ),
#'   ResultConfiguration = list(
#'     OutputLocation = "string",
#'     EncryptionConfiguration = list(
#'       EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'       KmsKey = "string"
#'     )
#'   ),
#'   WorkGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_start_query_execution
athena_start_query_execution <- function(QueryString, ClientRequestToken = NULL, QueryExecutionContext = NULL, ResultConfiguration = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "StartQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_query_execution_input(QueryString = QueryString, ClientRequestToken = ClientRequestToken, QueryExecutionContext = QueryExecutionContext, ResultConfiguration = ResultConfiguration, WorkGroup = WorkGroup)
  output <- .athena$start_query_execution_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_query_execution <- athena_start_query_execution

#' Stops a query execution
#'
#' Stops a query execution. Requires you to have access to the workgroup in
#' which the query ran.
#' 
#' For code samples using the AWS SDK for Java, see [Examples and Code
#' Samples](http://docs.aws.amazon.com/athena/latest/ug/code-samples.html)
#' in the *Amazon Athena User Guide*.
#'
#' @usage
#' athena_stop_query_execution(QueryExecutionId)
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_query_execution(
#'   QueryExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_stop_query_execution
athena_stop_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "StopQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$stop_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$stop_query_execution_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$stop_query_execution <- athena_stop_query_execution

#' Adds one or more tags to the resource, such as a workgroup
#'
#' Adds one or more tags to the resource, such as a workgroup. A tag is a
#' label that you assign to an AWS Athena resource (a workgroup). Each tag
#' consists of a key and an optional value, both of which you define. Tags
#' enable you to categorize resources (workgroups) in Athena, for example,
#' by purpose, owner, or environment. Use a consistent set of tag keys to
#' make it easier to search and filter workgroups in your account. For best
#' practices, see [AWS Tagging
#' Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' The key length is from 1 (minimum) to 128 (maximum) Unicode characters
#' in UTF-8. The tag value length is from 0 (minimum) to 256 (maximum)
#' Unicode characters in UTF-8. You can use letters and numbers
#' representable in UTF-8, and the following characters: + - = . \\_ : / @.
#' Tag keys and values are case-sensitive. Tag keys must be unique per
#' resource. If you specify more than one, separate them by commas.
#'
#' @usage
#' athena_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; Requests that one or more tags are added to the resource (such as a
#' workgroup) for the specified ARN.
#' @param Tags &#91;required&#93; One or more tags, separated by commas, to be added to the resource, such
#' as a workgroup.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_tag_resource
athena_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .athena$tag_resource_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$tag_resource <- athena_tag_resource

#' Removes one or more tags from the workgroup resource
#'
#' Removes one or more tags from the workgroup resource. Takes as an input
#' a list of TagKey Strings separated by commas, and removes their tags at
#' the same time.
#'
#' @usage
#' athena_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; Removes one or more tags from the workgroup resource for the specified
#' ARN.
#' @param TagKeys &#91;required&#93; Removes the tags associated with one or more tag keys from the workgroup
#' resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_untag_resource
athena_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .athena$untag_resource_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$untag_resource <- athena_untag_resource

#' Updates the workgroup with the specified name
#'
#' Updates the workgroup with the specified name. The workgroup\'s name
#' cannot be changed.
#'
#' @usage
#' athena_update_work_group(WorkGroup, Description, ConfigurationUpdates,
#'   State)
#'
#' @param WorkGroup &#91;required&#93; The specified workgroup that will be updated.
#' @param Description The workgroup description.
#' @param ConfigurationUpdates The workgroup configuration that will be updated for the given
#' workgroup.
#' @param State The workgroup state that will be updated for the given workgroup.
#'
#' @section Request syntax:
#' ```
#' svc$update_work_group(
#'   WorkGroup = "string",
#'   Description = "string",
#'   ConfigurationUpdates = list(
#'     EnforceWorkGroupConfiguration = TRUE|FALSE,
#'     ResultConfigurationUpdates = list(
#'       OutputLocation = "string",
#'       RemoveOutputLocation = TRUE|FALSE,
#'       EncryptionConfiguration = list(
#'         EncryptionOption = "SSE_S3"|"SSE_KMS"|"CSE_KMS",
#'         KmsKey = "string"
#'       ),
#'       RemoveEncryptionConfiguration = TRUE|FALSE
#'     ),
#'     PublishCloudWatchMetricsEnabled = TRUE|FALSE,
#'     BytesScannedCutoffPerQuery = 123,
#'     RemoveBytesScannedCutoffPerQuery = TRUE|FALSE
#'   ),
#'   State = "ENABLED"|"DISABLED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname athena_update_work_group
athena_update_work_group <- function(WorkGroup, Description = NULL, ConfigurationUpdates = NULL, State = NULL) {
  op <- new_operation(
    name = "UpdateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_work_group_input(WorkGroup = WorkGroup, Description = Description, ConfigurationUpdates = ConfigurationUpdates, State = State)
  output <- .athena$update_work_group_output()
  svc <- .athena$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_work_group <- athena_update_work_group
