% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_data_set_permissions}
\alias{quicksight_update_data_set_permissions}
\title{Updates the permissions on a dataset}
\usage{
quicksight_update_data_set_permissions(AwsAccountId, DataSetId,
  GrantPermissions, RevokePermissions)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSetId}{[required] The ID for the dataset whose permissions you want to update. This ID is
unique per AWS Region for each AWS account.}

\item{GrantPermissions}{The resource permissions that you want to grant to the dataset.}

\item{RevokePermissions}{The resource permissions that you want to revoke from the dataset.}
}
\value{
A list with the following syntax:\preformatted{list(
  DataSetArn = "string",
  DataSetId = "string",
  RequestId = "string",
  Status = 123
)
}
}
\description{
Updates the permissions on a dataset.

The permissions resource is
\code{arn:aws:quicksight:region:aws-account-id:dataset/data-set-id}.
}
\section{Request syntax}{
\preformatted{svc$update_data_set_permissions(
  AwsAccountId = "string",
  DataSetId = "string",
  GrantPermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RevokePermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
