% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_start_application}
\alias{kinesisanalyticsv2_start_application}
\title{Starts the specified Kinesis Data Analytics application}
\usage{
kinesisanalyticsv2_start_application(ApplicationName, RunConfiguration)
}
\arguments{
\item{ApplicationName}{[required] The name of the application.}

\item{RunConfiguration}{[required] Identifies the run configuration (start parameters) of a Kinesis Data
Analytics application.}
}
\value{
An empty list.
}
\description{
Starts the specified Kinesis Data Analytics application. After creating
an application, you must exclusively call this operation to start your
application.
}
\section{Request syntax}{
\preformatted{svc$start_application(
  ApplicationName = "string",
  RunConfiguration = list(
    FlinkRunConfiguration = list(
      AllowNonRestoredState = TRUE|FALSE
    ),
    SqlRunConfigurations = list(
      list(
        InputId = "string",
        InputStartingPositionConfiguration = list(
          InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
        )
      )
    ),
    ApplicationRestoreConfiguration = list(
      ApplicationRestoreType = "SKIP_RESTORE_FROM_SNAPSHOT"|"RESTORE_FROM_LATEST_SNAPSHOT"|"RESTORE_FROM_CUSTOM_SNAPSHOT",
      SnapshotName = "string"
    )
  )
)
}
}

\keyword{internal}
