% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_create_application_presigned_url}
\alias{kinesisanalyticsv2_create_application_presigned_url}
\title{Creates and returns a URL that you can use to connect to an
application's extension}
\usage{
kinesisanalyticsv2_create_application_presigned_url(ApplicationName,
  UrlType, SessionExpirationDurationInSeconds)
}
\arguments{
\item{ApplicationName}{[required] The name of the application.}

\item{UrlType}{[required] The type of the extension for which to create and return a URL.
Currently, the only valid extension URL type is \code{FLINK_DASHBOARD_URL}.}

\item{SessionExpirationDurationInSeconds}{The duration in seconds for which the returned URL will be valid.}
}
\value{
A list with the following syntax:\preformatted{list(
  AuthorizedUrl = "string"
)
}
}
\description{
Creates and returns a URL that you can use to connect to an
application's extension. Currently, the only available extension is the
Apache Flink dashboard.

The IAM role or user used to call this API defines the permissions to
access the extension. Once the presigned URL is created, no additional
permission is required to access this URL. IAM authorization policies
for this API are also enforced for every HTTP request that attempts to
connect to the extension.

The URL that you get from a call to CreateApplicationPresignedUrl must
be used within 3 minutes to be valid. If you first try to use the URL
after the 3-minute limit expires, the service returns an HTTP 403
Forbidden error.
}
\section{Request syntax}{
\preformatted{svc$create_application_presigned_url(
  ApplicationName = "string",
  UrlType = "FLINK_DASHBOARD_URL",
  SessionExpirationDurationInSeconds = 123
)
}
}

\keyword{internal}
