% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_databases}
\alias{athena_list_databases}
\title{Lists the databases in the specified data catalog}
\usage{
athena_list_databases(CatalogName, NextToken, MaxResults)
}
\arguments{
\item{CatalogName}{[required] The name of the data catalog that contains the databases to return.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}

\item{MaxResults}{Specifies the maximum number of results to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  DatabaseList = list(
    list(
      Name = "string",
      Description = "string",
      Parameters = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the databases in the specified data catalog.
}
\section{Request syntax}{
\preformatted{svc$list_databases(
  CatalogName = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
