% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_vpc_configuration}
\alias{kinesisanalyticsv2_add_application_vpc_configuration}
\title{Adds a Virtual Private Cloud (VPC) configuration to the application}
\usage{
kinesisanalyticsv2_add_application_vpc_configuration(ApplicationName,
  CurrentApplicationVersionId, VpcConfiguration)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{CurrentApplicationVersionId}{[required] The version of the application to which you want to add the VPC
configuration. You can use the DescribeApplication operation to get the
current application version. If the version specified is not the current
version, the \code{ConcurrentModificationException} is returned.}

\item{VpcConfiguration}{[required] Description of the VPC to add to the application.}
}
\description{
Adds a Virtual Private Cloud (VPC) configuration to the application.
Applications can use VPCs to store and access resources securely.

Note the following about VPC configurations for Kinesis Data Analytics
applications:
\itemize{
\item VPC configurations are not supported for SQL applications.
\item When a VPC is added to a Kinesis Data Analytics application, the
application can no longer be accessed from the Internet directly. To
enable Internet access to the application, add an Internet gateway
to your VPC.
}
}
\section{Request syntax}{
\preformatted{svc$add_application_vpc_configuration(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  VpcConfiguration = list(
    SubnetIds = list(
      "string"
    ),
    SecurityGroupIds = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
