% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sensmod.R
\name{plot.sensmod}
\alias{plot.sensmod}
\title{Plot absorbance spectra from \code{\link[=sensmodel]{sensmodel()}}}
\usage{
\method{plot}{sensmod}(
  x,
  select = NULL,
  type = c("overlay", "stack", "heatmap"),
  varying = NULL,
  n = 100,
  labels.stack = NULL,
  wl.guide = TRUE,
  ...
)
}
\arguments{
\item{x}{(required) a data frame, possibly an object of class \code{rspec}, with a
column with wavelength data, named 'wl', and the remaining column
containing spectra to plot.}

\item{select}{specification of which spectra to plot. Can be a numeric vector
or factor (e.g., \code{sex=="male"})}

\item{type}{what type of plot should be drawn. Possibilities are:
\itemize{
\item \code{overlay} (default) for plotting multiple spectra in a single panel with
a common y-axis.
\item \code{stack} for plotting multiple spectra in a vertical arrangement.
\item \code{heatmap} for plotting reflectance values by wavelength and a third
variable (\code{varying}).
}}

\item{varying}{a numeric vector giving values for y-axis in
\code{type = "heatmap"}.}

\item{n}{number of bins with which to interpolate colors and \code{varying} for
the heatplot.}

\item{labels.stack}{a vector of labels for the stacked spectra when using
\code{type = "stack"}. Defaults to the numeric column ID's.}

\item{wl.guide}{logical determining whether visible light spectrum should be
added to the x-axis.}

\item{...}{additional arguments passed to \code{\link[=plot]{plot()}} (or \code{\link[=image]{image()}} for
\code{"heatmap"}).}
}
\description{
Plot absorbance spectra from \code{\link[=sensmodel]{sensmodel()}}
}
\examples{
# Blue tit visual system based on Hart et al (2000)
bluesens <- sensmodel(c(371, 448, 502, 563),
  beta = FALSE,
  lambdacut = c(330, 413, 507, 572),
  oiltype = c("T", "C", "Y", "R"), om = TRUE
)
plot(bluesens)

# Alternatively, you can specify your own ylab
plot(bluesens, ylab = "absor.")

}
\seealso{
\code{\link[=plot.rspec]{plot.rspec()}}, \code{\link[=sensmodel]{sensmodel()}}
}
