% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reducers.R
\name{reduce_cluster}
\alias{reduce_cluster}
\alias{map_cluster}
\title{Reduce a target}
\usage{
reduce_cluster(.partition_step, .f, first_match = FALSE)

map_cluster(.partition_step, .f, rewind = FALSE, first_match = FALSE)
}
\arguments{
\item{.partition_step}{a \code{partition_step} object}

\item{.f}{a function to reduce the data to either a vector or a data.frame}

\item{first_match}{logical. Should the partition algorithm stop when it finds
a reduction that is equal to the threshold? Default is \code{TRUE} for reducers
that return a \code{data.frame} and \code{FALSE} for reducers that return a vector}

\item{rewind}{logical. Should the last target be used instead of the
current target?}
}
\value{
a \code{partition_step} object
}
\description{
\code{reduce_cluster()} and \code{map_cluster()} apply the data reduction to the targets
found in the director step. They only do so if the metric is above the
threshold, however. \code{reduce_cluster()} is for functions that return vectors
while \code{map_cluster()} is for functions that return \code{data.frames}. If you're
using \code{\link[=as_reducer]{as_reducer()}}, there's no need to call these functions directly.
}
\examples{

reduce_row_means <- function(.partition_step, .data) {
  reduce_cluster(.partition_step, rowMeans)
}

replace_partitioner(
  part_icc,
  reduce = reduce_row_means
)

}
