% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters_table.R
\name{parameters_table}
\alias{parameters_table}
\title{Parameters Table Formatting}
\usage{
parameters_table(x, pretty_names = TRUE, stars = FALSE, ...)
}
\arguments{
\item{x}{A dataframe of model's parameters.}

\item{pretty_names}{Pretty parameters' names.}

\item{stars}{Add significance stars (e.g., p < .001***).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data.frame.
}
\description{
Parameters Table Formatting
}
\examples{
library(parameters)

x <- model_parameters(lm(Sepal.Length ~ Species * Sepal.Width, data = iris))
as.data.frame(parameters_table(x))
\donttest{
library(rstanarm)
x <- model_parameters(stan_glm(Sepal.Length ~ Species, data = iris), ci = c(0.69, 0.89, 0.95))
as.data.frame(parameters_table(x))
}

}
