% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_p.R
\name{format_p}
\alias{format_p}
\title{p-values formatting}
\usage{
format_p(p, stars = FALSE, stars_only = FALSE, name = "p",
  missing = "", digits = 3, ...)
}
\arguments{
\item{p}{value or vector of p-values.}

\item{stars}{Add significance stars (e.g., p < .001***).}

\item{stars_only}{Return only significance stars.}

\item{name}{Name prefixing the text. Can be \code{NULL}.}

\item{missing}{Value by which \code{NA} values are replaced. By default, an empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{digits}{Number of significant digits. May also be \code{"scientific"} to return exact p-values in scientific notation, or \code{"apa"} to use an APA-style for p-values.}

\item{...}{Arguments from other methods.}
}
\value{
A formatted string.
}
\description{
Format p-values.
}
\examples{
format_p(c(.02, .065, 0, .23))
format_p(c(.02, .065, 0, .23), name = NULL)
format_p(c(.02, .065, 0, .23), stars_only = TRUE)

model <- lm(mpg ~ wt + cyl, data = mtcars)
format_p(p_value(model)$p, digits = "scientific")

}
