% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.glmmTMB.R,
%   R/model_parameters.lme.R, R/model_parameters.merMod.R
\name{model_parameters.glmmTMB}
\alias{model_parameters.glmmTMB}
\alias{model_parameters.lme}
\alias{model_parameters.merMod}
\title{Mixed Model Parameters}
\usage{
\method{model_parameters}{glmmTMB}(model, ci = 0.95,
  standardize = FALSE, standardize_robust = FALSE, bootstrap = FALSE,
  iterations = 1000, component = c("all", "conditional", "zi",
  "zero_inflated"), ...)

\method{model_parameters}{lme}(model, ci = 0.95, standardize = FALSE,
  standardize_robust = FALSE, bootstrap = FALSE, iterations = 1000,
  ...)

\method{model_parameters}{merMod}(model, ci = 0.95,
  standardize = FALSE, standardize_robust = FALSE, bootstrap = FALSE,
  p_method = "wald", ci_method = "wald", iterations = 1000, ...)
}
\arguments{
\item{model}{A mixed model.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{standardize}{Add standardized parameters. Can be \code{FALSE} or a character indicating the standardization method (see \code{\link[=parameters_standardize]{parameters_standardize()}}), such as \code{"refit"}, \code{"2sd"}, \code{"smart"} or \code{"classic"}. The two former are based on model refitting using a standardized version of data. It is the most accurate, although computationally heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link[=parameters_standardize]{parameters_standardize}}.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If \code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also \code{\link[=parameters_bootstrap]{parameters_bootstrap()}}).}

\item{iterations}{The number of draws to simulate/bootstrap.}

\item{component}{Should all parameters, parameters for the conditional model,
or for the zero-inflated part of the model be returned? Applies to models
with zero-inflated component. \code{component} may be one of \code{"conditional"},
\code{"zi"}, \code{"zero-inflated"} or \code{"all"} (default). May be abbreviated.}

\item{...}{Arguments passed to or from other methods.}

\item{p_method}{Method for computing p values. See \code{\link[=p_value]{p_value()}}.}

\item{ci_method}{Method for computing confidence intervals (CI). See \code{\link[=ci]{ci()}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters of mixed models.
}
\examples{
library(parameters)
library(lme4)
library(glmmTMB)

model <- lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, standardize = "refit")

model <- glmmTMB(
  count ~ spp + mined + (1 | site),
  ziformula = ~mined,
  family = poisson(),
  data = Salamanders
)
model_parameters(model)
\donttest{
model <- lme4::lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, standardize = "smart", bootstrap = TRUE, iterations = 50)
}

}
\seealso{
\code{\link[=standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
