#' @rdname model_parameters.lm
#' @export
model_parameters.polr <- function(model, ci = .95, bootstrap = FALSE, iterations = 1000, ...) {
  # Processing
  if (bootstrap) {
    parameters <- parameters_bootstrap(model, iterations = iterations, ci = ci, ...)
  } else {
    parameters <- .extract_parameters_generic(model, ci = ci, component = "conditional", merge_by = "Parameter")
  }

  attr(parameters, "pretty_names") <- format_parameters(model)
  attr(parameters, "ci") <- ci
  class(parameters) <- c("parameters_model", "see_parameters_model", class(parameters))
  parameters
}


#' @export
model_parameters.clm2 <- model_parameters.polr


#' @export
model_parameters.svyglm.nb <- model_parameters.polr


#' @export
model_parameters.svyglm.zip <- model_parameters.polr


#' @export
model_parameters.glimML <- model_parameters.polr


#' @export
model_parameters.tobit <- model_parameters.polr
