% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_htest.R
\name{model_parameters.htest}
\alias{model_parameters.htest}
\alias{model_parameters.pairwise.htest}
\title{Parameters from hypothesis tests}
\usage{
\method{model_parameters}{htest}(
  model,
  cramers_v = NULL,
  phi = NULL,
  standardized_d = NULL,
  hedges_g = NULL,
  omega_squared = NULL,
  eta_squared = NULL,
  epsilon_squared = NULL,
  cohens_g = NULL,
  rank_biserial = NULL,
  rank_epsilon_squared = NULL,
  kendalls_w = NULL,
  ci = 0.95,
  alternative = NULL,
  bootstrap = FALSE,
  verbose = TRUE,
  ...
)

\method{model_parameters}{pairwise.htest}(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{Object of class \code{htest} or \code{pairwise.htest}.}

\item{cramers_v, phi}{Compute Cramer's V or phi as index of effect size.
Can be \code{"raw"} or \code{"adjusted"} (effect size will be bias-corrected).
Only applies to objects from \code{chisq.test()}.}

\item{standardized_d}{If \code{TRUE}, compute standardized d as index of
effect size. Only applies to objects from \code{t.test()}. Calculation of
\code{d} is based on the t-value (see \code{\link[effectsize:t_to_r]{effectsize::t_to_d()}})
for details.}

\item{hedges_g}{If \code{TRUE}, compute Hedge's g as index of effect size.
Only applies to objects from \code{t.test()}.}

\item{omega_squared, eta_squared, epsilon_squared}{Logical, if \code{TRUE},
returns the non-partial effect size Omega, Eta or Epsilon squared. Only
applies to objects from \code{oneway.test()}.}

\item{cohens_g}{If \code{TRUE}, compute Cohen's g as index of effect size.
Only applies to objects from \code{mcnemar.test()}.}

\item{rank_biserial}{If \code{TRUE}, compute the rank-biserial correlation as
effect size measure. Only applies to objects from \code{wilcox.test()}.}

\item{rank_epsilon_squared}{If \code{TRUE}, compute the rank epsilon squared
as effect size measure. Only applies to objects from \code{kruskal.test()}.}

\item{kendalls_w}{If \code{TRUE}, compute the Kendall's coefficient of
concordance as effect size measure. Only applies to objects from
\code{friedman.test()}.}

\item{ci}{Level of confidence intervals for effect size statistic. Currently
only applies to objects from \code{chisq.test()} or \code{oneway.test()}.}

\item{alternative}{A character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed
(e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See section \emph{One-Sided CIs} in
the \href{https://easystats.github.io/effectsize/}{effectsize_CIs vignette}.}

\item{bootstrap}{Should estimates be bootstrapped?}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters of h-tests (correlations, t-tests, chi-squared, ...).
}
\examples{
model <- cor.test(mtcars$mpg, mtcars$cyl, method = "pearson")
model_parameters(model)

model <- t.test(iris$Sepal.Width, iris$Sepal.Length)
model_parameters(model)

model <- t.test(mtcars$mpg ~ mtcars$vs)
model_parameters(model)

model <- t.test(iris$Sepal.Width, mu = 1)
model_parameters(model)

data(airquality)
airquality$Month <- factor(airquality$Month, labels = month.abb[5:9])
model <- pairwise.t.test(airquality$Ozone, airquality$Month)
model_parameters(model)

smokers <- c(83, 90, 129, 70)
patients <- c(86, 93, 136, 82)
model <- pairwise.prop.test(smokers, patients)
model_parameters(model)
}
