% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.bayesian.R
\name{model_parameters.stanreg}
\alias{model_parameters.stanreg}
\title{Bayesian Models Parameters}
\usage{
\method{model_parameters}{stanreg}(model, centrality = "median",
  dispersion = FALSE, ci = 0.89, ci_method = "hdi", test = c("pd",
  "rope"), rope_range = "default", rope_ci = 1, bf_prior = NULL,
  diagnostic = c("ESS", "Rhat"), priors = TRUE, standardize = FALSE,
  standardize_robust = FALSE, iterations = 1000, ...)
}
\arguments{
\item{model}{Bayesian model.}

\item{centrality}{The point-estimates (centrality indices) to compute.  Character (vector) or list with one or more of these options: \code{"median"}, \code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{dispersion}{Logical, if \code{TRUE}, computes indices of dispersion related to the estimate(s) (\code{SD} and \code{MAD} for \code{mean} and \code{median}, respectively).}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{ci_method}{The type of index used for Credible Interval. Can be
\code{"HDI"} (default, see \code{\link{hdi}}) or \code{"ETI"}
(see \code{\link{eti}}).}

\item{test}{The indices of effect existence to compute. Character (vector) or
list with one or more of these options: \code{"p_direction"} (or \code{"pd"}),
\code{"rope"}, \code{"p_map"}, \code{"equivalence_test"} (or \code{"equitest"}),
\code{"bayesfactor"} (or \code{"bf"}) or \code{"all"} to compute all tests.#'
For each "test", the corresponding \pkg{bayestestR} function is called
(e.g. \code{\link{rope}} or \code{\link{p_direction}}) and its results
included in the summary output.}

\item{rope_range}{ROPE's lower and higher bounds. Should be a list of two
values (e.g., \code{c(-0.1, 0.1)}) or \code{"default"}. If \code{"default"},
the bounds are set to \code{x +- 0.1*SD(response)}.}

\item{rope_ci}{The Credible Interval (CI) probability, corresponding to the
proportion of HDI, to use for the percentage in ROPE.}

\item{bf_prior}{Distribution representing a prior for the computation of Bayes factors. Used if the input is a posterior, otherwise (in the case of models) ignored.}

\item{diagnostic}{Diagnostic metrics to compute.  Character (vector) or list with one or more of these options: \code{"ESS"}, \code{"Rhat"}, \code{"MCSE"} or \code{"all"}.}

\item{priors}{Add the prior used for each parameter.}

\item{standardize}{Add standardized parameters. Can be FALSE or a character indicating the standardization method (see \code{\link{parameters_standardize}}), such as "refit", "2sd", "smart" or "classic". The two formers are based on model refitting using a standardized version of data. It is the most accurate, altough computationnaly heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link{parameters_standardize}}.}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootsrapped frequentist models.}

\item{...}{Arguments passed to or from other methods (e.g., to \link[=standardize.lm]{standardize}).}
}
\value{
A data.frame of indices related to the model's parameters.
}
\description{
Parameters of Bayesian models.
}
\examples{
\donttest{
library(parameters)
library(rstanarm)

model <- rstanarm::stan_glm(Sepal.Length ~ Petal.Length * Species,
  data = iris, iter = 500, refresh = 0
)

model_parameters(model, standardize = "smart")
}

}
