% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.merMod.R
\name{model_parameters.merMod}
\alias{model_parameters.merMod}
\title{Mixed Model Parameters}
\usage{
\method{model_parameters}{merMod}(model, ci = 0.95,
  standardize = "refit", standardize_robust = FALSE,
  bootstrap = FALSE, p_method = "wald", ci_method = "wald",
  iterations = 1000, ...)
}
\arguments{
\item{model}{Frequentist regression object.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{standardize}{Add standardized parameters. Can be FALSE or a character indicating the standardization method (see \code{\link{parameters_standardize}}), such as "refit", "2sd", "smart" or "classic". The two formers are based on model refitting using a standardized version of data. It is the most accurate, altough computationnaly heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link{parameters_standardize}}.}

\item{bootstrap}{Should estimates be based on bootsrapped model? If TRUE, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply.}

\item{p_method}{Method for computing p values. See \link{p_value}.}

\item{ci_method}{Method for computing confidence intervals (CI). See \link{ci}.}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootsrapped frequentist models.}

\item{...}{Arguments passed to or from other methods (e.g., to \link[=standardize.lm]{standardize}).}
}
\value{
A data.frame of indices related to the model's parameters.
}
\description{
Parameters of mixed models.
}
\examples{
library(parameters)
library(lme4)

model <- lme4::lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, standardize = "refit")

model <- lme4::glmer(vs ~ wt + (1 | gear), data = mtcars, family = "binomial")
model_parameters(model)
\donttest{
model <- lme4::lmer(mpg ~ wt + (1 | gear), data = mtcars)
model_parameters(model, standardize = "smart", bootstrap = TRUE, iterations = 50)
}

}
