% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeroc_auc.R
\name{timeroc_auc}
\alias{timeroc_auc}
\title{timeroc_auc}
\usage{
timeroc_auc(obj)
}
\arguments{
\item{obj}{A predictTROC object.\cr}
}
\value{
A dataframe of the area under the ROC curve
}
\description{
Function to compute the area under the ROC curve
}
\examples{
test <- timeroc_obj('normal-weibull-copula', copula = 'clayton90')
print(test)

set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0.1, n=500,
               params.t = c(shape=1, scale=5),
               params.x = c(mean=5, sd=1),
               params.copula=-2)

cc <- timeroc_fit(x=rr$x, t=rr$t, event=rr$event, obj = test)

jj <- timeroc_predict(cc, t = quantile(rr$t, probs = c(0.25,0.5,0.75)))

timeroc_auc(jj)
}
