% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative-effect.R, R/viz-elra.R
\name{get_cumu_eff}
\alias{get_cumu_eff}
\alias{gg_cumu_eff}
\title{Calculate (or plot) cumulative effect for all time-points of the follow-up}
\usage{
get_cumu_eff(data, model, term, z1, z2 = NULL, se_mult = 2)

gg_cumu_eff(data, model, term, z1, z2 = NULL, se_mult = 2, ci = TRUE)
}
\arguments{
\item{data}{Data used to fit the \code{model}.}

\item{model}{A suitable model object which will be used to estimate the
partial effect of \code{term}.}

\item{term}{A character string indicating the model term for which partial
effects should be plotted.}

\item{z1}{The exposure profile for which to calculate the cumulative effect.
Can be either a single number or a vector of same length as unique observation
time points.}

\item{z2}{If provided, calculated cumulative effect is for the difference
between the two exposure profiles (g(z1,t)-g(z2,t)).}

\item{se_mult}{Multiplicative factor used to calculate confidence intervals
(e.g., lower = fit - 2*se).}

\item{ci}{Logical. Indicates if confidence intervals for the \code{term}
of interest should be calculated/plotted. Defaults to \code{TRUE}.}
}
\description{
Calculate (or plot) cumulative effect for all time-points of the follow-up
}
