% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walsby.R
\name{walsby_generate_regression_ETR_II}
\alias{walsby_generate_regression_ETR_II}
\title{Walsby Regression for ETR II}
\usage{
walsby_generate_regression_ETR_II(
  data,
  etr_max_start_value = walsby_default_start_value_etr_max,
  alpha_start_value = walsby_default_start_value_alpha,
  beta_start_value = walsby_default_start_value_beta
)
}
\arguments{
\item{data}{A \code{data.table} from \code{read_dual_pam_data}.}

\item{etr_max_start_value}{Numeric. Initial value for \eqn{ETR_{max}}. Default: \code{etr_max_start_value_walsby_default}.}

\item{alpha_start_value}{Numeric. Initial value for \eqn{\alpha}. Default: \code{alpha_start_value_walsby_default}.}

\item{beta_start_value}{Numeric. Initial value for \eqn{\beta}. Default: \code{beta_start_value_walsby_default}.}
}
\value{
A list containing:
\itemize{
  \item \code{etr_regression_data}: Predicted ETR values.
  \item \code{sdiff}: Deviation between actual and predicted ETR.
  \item \code{etr_max}: Maximum ETR (\eqn{ETR_{max}}).
  \item \code{alpha}: Initial slope (\eqn{\alpha}).
  \item \code{beta}: Photoinhibition factor (\eqn{\beta}).
}
}
\description{
Fits a modified Walsby (1997) regression model without the respiration term, using Romoth (2019) naming conventions.
Calculates \eqn{ETR_{max}} without accounting for photoinhibition.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#walsby_generate_regression_etr_i-and-walsby_generate_regression_etr_ii}.
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- walsby_generate_regression_ETR_II(data)

}
\references{
{
  Walsby, A. E. (1997). Numerical integration of phytoplankton photosynthesis through time and depth in a water column.
  \emph{New Phytologist}, 136(2), 189-209. Available at: \doi{10.1046/j.1469-8137.1997.00736.x}

Romoth, K., Nowak, P., Kempke, D., Dietrich, A., Porsche, C., & Schubert, H. (2019).
  Acclimation limits of \emph{Fucus evanescens} along the salinity gradient of the southwestern Baltic Sea.
  \emph{Botanica Marina}, 62(1), 1-12. Available at: \doi{10.1515/bot-2018-0098}
}
}
