% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors_discrete.R
\name{discrete}
\alias{discrete}
\alias{alphabet}
\alias{alphabet2}
\alias{cols25}
\alias{glasbey}
\alias{kelly}
\alias{polychrome}
\alias{stepped}
\alias{stepped2}
\alias{stepped3}
\alias{okabe}
\alias{tableau20}
\alias{tol}
\alias{tol.groundcover}
\alias{watlington}
\title{Discrete palettes}
\usage{
alphabet(n = 26)

alphabet2(n = 26)

cols25(n = 25)

glasbey(n = 32)

kelly(n = 22)

polychrome(n = 36)

stepped(n = 24)

stepped2(n = 20)

stepped3(n = 20)

okabe(n = 8)

tableau20(n = 20)

tol(n = 12)

tol.groundcover(n = 14)

watlington(n = 16)
}
\arguments{
\item{n}{Number of colors to return.}
}
\value{
A vector of colors as hex strings.
}
\description{
Color palettes designed for discrete, categorical data with a small number of
categories.
}
\details{
The \code{alphabet} palette has 26 distinguishable colors that have logical names
starting with the English alphabet letters A, B, ... Z.
This palette is based on the work by Green-Armytage (2010), but uses the
names 'orange' instead of 'orpiment', and 'magenta' instead of 'mallow'. 

The \code{alphabet2} palette uses a similar idea with slightly different colors
and slightly different names.  This palette comes from the Polychrome package,
generated with the \code{createPalette} function and then manually
arranged and named.

The \code{cols25} palette was created experimentally by Wright (unpublished)
to create a set of colors that are distinct.

The \code{glasbey} palette by Glasbey et al (2007) has 32 colors that are
maximally distinct. Glasbey has 'white' as the second color, but in this
version of the palette, the color 'white' is moved to the end, and is
actually light-gray, #F2F3F4.

The \code{kelly} palette of 22 colors maximize the contrast
between colors in a set if the colors are chosen in sequential order.
Kelly paid attention to the needs of people with color blindness.  The
first nine colors work well for such people and people with normal vision.
Kelly did not provide RGB color values, and the paper was in black-and-white.
A color image of the Kelly palette can be found in Green-Armytage (2010).
The color 'white' has been re-defined as light-gray, #F2F3F4.
Commentary: We think the kelly palette has an over-abundance of orange-ish
colors, the purples are not very distinct, color 22 (olive green) is almost
identical to color 2 (black), etc.

The \code{okabe} palette was design to be (1) clear for both colorblind and
non-colorblind people, (2) vividly colored, and (3) good for screen and printed.
The color-blind simulation tools in R suggest this palette is not as useful
as hoped.

The \code{polychrome} palette is also from the Polychrome package.
Colors were given a name from the ISCC-NBS standard.

The \code{stepped} palette has 24 colors (5 hues, 4 levels within each hue, plus
4 shades of gray) that is useful for showing varying levels within categories.
Inspired by (http://geog.uoregon.edu/datagraphics/color_scales.htm), but in
order to better separate these colors in RGB space, red hue 0 was moved to hue 350,
green hue 80 moved to hue 90. The number of colors within each hue was reduced
from 5 to 4, and gray shades were added.

\code{stepped2} and \code{stepped3} are from the 'vega' package
https://github.com/vega/vega/wiki/Scales.

The \code{tableau20} palette has 10 pairs of dark/light colors that are used by
the Tableau software.

The \code{tol} palette has 12 colors by Paul Tol.

The \code{watlington} palette has 16 colors.
The color 'white' has been re-defined as light-gray, #F2F3F4.
}
\examples{

pal.bands(alphabet, alphabet2, cols25, glasbey, kelly, okabe, polychrome,
  tableau20, tol, watlington)
pal.bands(stepped, stepped2, stepped3)
pal.bands(tol.groundcover)

\dontrun{
alphabet()
alphabet()["jade"]
pal.bands(alphabet,n=26)
pal.heatmap(alphabet)
# pal.cube(alphabet)

pal.heatmap(alphabet2)

pal.heatmap(cols25)

pal.heatmap(glasbey())
# pal.cube(glasbey, n=32) # Blues are close together

pal.heatmap(kelly()) # too many orange/pink colors

pal.safe(okabe()) # not great

pal.heatmap(polychrome)

pal.heatmap(stepped, n=24)

pal.heatmap(stepped2, n=20)

pal.heatmap(stepped3, n=20)

pal.heatmap(tol, 12)

pal.heatmap(watlington(16))
}

}
\references{
Robert M. Boynton. (1989)
Eleven Colors That Are Almost Never Confused. 
Proc. SPIE 1077, \emph{Human Vision, Visual Processing, and Digital Display}, 322-332.
http://doi.org/10.1117/12.952730

Kevin R. Coombes (2016). Polychrome.
https://rdrr.io/rforge/Polychrome/man/alphabet.html

Chris Glasbey, Gerie van der Heijden, Vivian F. K. Toh, Alision Gray (2007).
Colour Displays for Categorical Images.
\emph{Color Research and Application}, 32, 304-309.
http://doi.org/10.1002/col.20327

P. Green-Armytage (2010): A Colour Alphabet and the Limits of Colour Coding.
\emph{Colour: Design & Creativity} (5) (2010): 10, 1-23.
www.aic-color.org/journal/v5/jaic_v5_06.pdf

K. Kelly (1965): Twenty-two colors of maximum contrast.
\emph{Color Eng}., 3(6), 1965.
http://www.iscc.org/pdf/PC54_1724_001.pdf

Masataka Okabe and Kei Ito (2002).
Color Universal Design (CUD) - How to make figures and presentations
that are friendly to Colorblind people.
http://jfly.iam.u-tokyo.ac.jp/color/

Paul Tol (2012). Color Schemes. SRON technical note, SRON/EPS/TN/09-002.
https://personal.sron.nl/~pault/

John Watlington.
An Optimum 16 Color Palette.
http://alumni.media.mit.edu/~wad/color/palette.html

Color Schemes Appropriate for Scientific Data Graphics
http://geog.uoregon.edu/datagraphics/color_scales.htm
}
\author{
Palette colors by various authors. R code by Kevin Wright.
}
