% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{rmeana}
\alias{rmeana}
\title{Calculate a rolling mean based on distance within a second variable.}
\usage{
rmeana(x0, y0, x1 = NULL, plusminus = 5, weighting = FALSE, weightdiff = 0)
}
\arguments{
\item{x0}{Numeric independent variable at which rolling mean is to be calculated.}

\item{y0}{Numeric variable of which mean is to be calculated.}

\item{x1}{Optional. New x values at which rolling mean of y0 is to be calculated. If x1==NULL, calculation will take place at original (x0) values.}

\item{plusminus}{Criterium for the width (in x0) of the interval over which rolling mean values are to be calculated. Value represents the margin as calculated from every value of x1 or x0, i.e. for a plusminus==5, the interval over which the means are drawn will range from values with x-x_i=5 to x-x_i=-5.}

\item{weighting}{Whether or not to apply weighting. If weighting==TRUE, then means are calculated as weighted means with weighting decreasing linearly towards the margins of the interval over which the mean is to be drawn.}

\item{weightdiff}{Minimum weight to be added to all weights if weighting==TRUE. Defaults to 0.}
}
\value{
A numeric vector of the same length as either x1 (if not NULL) or x0, containing the calculated rolling means.
}
\description{
Calculate a rolling mean based on distance within a second variable.
}
\examples{
rmeana(x0=c(1,2,3,4,5,6), y0=c(2,3,3,4,5,6))
}
