% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_unload.R
\name{p_unload}
\alias{p_unload}
\title{Unloads package(s)}
\usage{
p_unload(..., negate = FALSE, char, character.only = FALSE)
}
\arguments{
\item{negate}{logical. If \code{TRUE} will unload
all add on packages except those provided to \code{p_unload}.}

\item{char}{Character vector containing packages to load.  If you are calling
\code{p_unload} from within a function (or just having difficulties calling it 
using a character vector input) then pass your character vector of packages 
to load to this parameter directly.}

\item{character.only}{logical. If \code{TRUE} then \code{p_unload} will only 
accept a single input which is a character vector containing the names of 
packages to load.}

\item{\dots}{name of package(s) or "all" (all removes all add on packages).}
}
\description{
Unloads package(s) or all packages.
}
\note{
\code{p_unload} will not unload the base install packages that load 
when R boots up.  See the comments in the help for \code{detach} about some 
issues with unloading and reloading namespaces.
}
\examples{
\dontrun{
p_load(lattice)
p_loaded()
p_unload(lattice)
p_loaded()

p_load("lattice", "MASS")
p_loaded()
p_unload(all)
p_loaded() # will not work as you unloaded pacman

library(pacman)
p_load(lattice, MASS, foreign)
p_loaded()
p_unload(pacman, negate=TRUE)
p_loaded()
}
}
\seealso{
\code{\link[base]{detach}}
}
\keyword{detach}
\keyword{package}

