% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_boot.R
\name{p_boot}
\alias{p_boot}
\title{Script Header: Ensure \pkg{pacman} is Installed}
\usage{
p_boot(load = TRUE, copy2clip = interactive())
}
\arguments{
\item{load}{logical.  If \code{TRUE} \code{; library(pacman)} is added to the 
end of the script header.}

\item{copy2clip}{logical.  If \code{TRUE} attempts to copy the output to the 
clipboard.}
}
\value{
Returns a script header string (optionally copies to the clipboard).
}
\description{
Generate a string for the standard \pkg{pacman} script header that, when
added to scripts, will ensure \pkg{pacman} is installed before attempting to 
use it.  \pkg{pacman} will attempt to copy this string (standard script 
header) to the clipboard for easy cut and paste.
}
\details{
The script header takes the form of: 

 \code{if (!require("pacman")) install.packages("pacman"); library(pacman)}

This can be copied to the top of scripts to make it easy to run scripts if 
the user shares them with others or to aid in long term script management.  
This may also be useful for blog posts and \pkg{R} help sites like 
\href{http://www.talkstats.com/}{TalkStats} or 
\href{http://stackoverflow.com/questions/tagged/r}{StackOverflow}.  In this 
way functions like \code{p_load} can be used without fear that others don't 
have \pkg{pacman} installed.
}
\examples{
p_boot()
}
\keyword{header}

