% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioconductorDownloads.R
\name{bioconductorDownloads}
\alias{bioconductorDownloads}
\title{Annual/monthly package downloads from Bioconductor (beta).}
\usage{
bioconductorDownloads(packages = NULL, from = NULL, to = NULL,
  when = NULL, observation = "month")
}
\arguments{
\item{packages}{Character. Vector of package names.}

\item{from}{Start date as \code{yyyy-mm} or \code{yyyy}.}

\item{to}{End date as \code{yyyy-mm} or \code{yyyy}.}

\item{when}{\code{"last-year"}, or \code{"year-to-date"} or \code{"ytd"}.}

\item{observation}{"year" or "month".}
}
\description{
Annual/monthly package downloads from Bioconductor (beta).
}
\examples{
\donttest{
# all packages
bioconductorDownloads()

# entire history
bioconductorDownloads(packages = "clusterProfiler")

# year-to-date
bioconductorDownloads(packages = "clusterProfiler", when = "ytd")
bioconductorDownloads(packages = "clusterProfiler", when = "year-to-date")

# last 12 months
bioconductorDownloads(packages = "clusterProfiler", when = "last-year")

# from 2015 to current year
bioconductorDownloads(packages = "clusterProfiler", from = 2015)

# 2015 through 2018 (yearly)
bioconductorDownloads(packages = "clusterProfiler", from = 2010, to = 2015, observation = "year")

# selected year (yearly)
bioconductorDownloads(packages = "clusterProfiler", from = 2015, to = 2015)

# selected year (monthly)
bioconductorDownloads(packages = "clusterProfiler", from = "2015-01", to = "2015-12")

# June 2014 through March 2018
bioconductorDownloads(packages = "clusterProfiler", from = "2014-06", to = "2015-03")
}
}
