% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{get_parameter_read}
\alias{get_parameter_read}
\title{Get the parameter values from reading a file}
\usage{
get_parameter_read(parameter, paramfile, strategycol = NA, strategyname = NA)
}
\arguments{
\item{parameter}{parameter of interest}

\item{paramfile}{parameter file to be provided}

\item{strategycol}{treatment strategy}

\item{strategyname}{treatment strategy name in the column strategycol}
}
\value{
the paramvalue
}
\description{
Get the parameter values from reading a file
}
\details{
This function read the parameter from a file given that
the file has these column names (at least) Parameter and Value
Strategy col and name are optional. Check if the data file contains
column names parameter and value and then get the results.
}
\examples{
a <- get_parameter_read("cost_IT", paramfile = system.file("extdata",
"table_param.csv", package = "packDAMipd"))
}
